/**
 * pp_pwmtach.h
 *
 * Public header file for PWM/Tacho core interface
 *
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppercon.de>
 *                        Michael Baumann <miba@peppercon.de>
 *
 */

#ifndef _PP_PWMTACH_H
#define _PP_PWMTACH_H

typedef struct {
    u_int8_t index;		/* (USER -> KERNEL) tach index */
    u_int8_t pulses_per_rev;	/* (USER -> KERNEL) tach pulses per revolution */
    u_int16_t revs_per_minute;	/* (KERNEL -> USER) revolutions per minute */
} pp_tach_data_t;

typedef struct {
    u_int8_t index;		/* (USER -> KERNEL) pwm index */
    u_int8_t duty_cycle;	/* (USER <-> KERNEL) duty cycle in percent */
    u_int    frequency;		/* (USER <-> KERNEL) pwm frequency */
} pp_pwm_data_t;

typedef struct {
    u_int8_t index;		/* (USER -> KERNEL) pwm index */
    u_int8_t activate;		/* (USER -> KERNEL) 1=switch pin to tach, 0=alternate */
} pp_pwm_init_t;

typedef struct {
    u_int8_t index;		/* (USER -> KERNEL) pwm index */
    u_int8_t activate;		/* (USER -> KERNEL) 1=switch pin to tach, 0=alternate */
} pp_tach_init_t;

#define PP_PWMTACH_IOCTL_MAGIC			'P'
#define PP_PWMTACH_IOCTL_TACH_GET_RPM		_IOWR (PP_PWMTACH_IOCTL_MAGIC,  1, pp_tach_data_t)
#define PP_PWMTACH_IOCTL_PWM_SET_PARAMS		_IOW  (PP_PWMTACH_IOCTL_MAGIC,  2, pp_pwm_data_t)
#define PP_PWMTACH_IOCTL_PWM_GET_PARAMS		_IOR  (PP_PWMTACH_IOCTL_MAGIC,  3, pp_pwm_data_t)

#define PP_PWMTACH_IOCTL_PWM_INIT		_IOW  (PP_PWMTACH_IOCTL_MAGIC,  4, pp_pwm_init_t)
#define PP_PWMTACH_IOCTL_TACH_INIT		_IOW  (PP_PWMTACH_IOCTL_MAGIC,  5, pp_tach_init_t)

#endif /* _PP_PWMTACH_H */
