/**
 * pwmtach_core.h
 *
 * Common header file for all low-level PWM/Tacho core drivers
 *
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

#ifndef __PWMTACH_CORE_H__
#define __PWMTACH_CORE_H__

#include <linux/types.h>

/* ------------------------------------------------------------------------- *
 * data types
 * ------------------------------------------------------------------------- */

#define PWMTACH_CORE_NAME_SIZE	16

/* possible capabilities of a core */
#define PWMTACH_CAPS_HAVE_PWM			0x01
#define PWMTACH_CAPS_HAVE_TACHO			0x02
#define PWMTACH_CAPS_PWM_FREQUENCY_SEPARATE	0x04

struct pwmtach_dev_s;

typedef struct pwmtach_core_s {
    struct pwmtach_dev_s *dev;	/* link to device structure */
    void*	private_data;	/* may be filled by the core */
    uint32_t	caps;		/* this core's capabilities */
    uint8_t	pwm_count;	/* number of pwm outputs this core can handle */
    uint8_t     tacho_count;	/* number of tacho inputs this core can handle */
    char	name[PWMTACH_CORE_NAME_SIZE];
    
    /* core operations */
    void	(*cleanup)	(struct pwmtach_core_s *core);
    
    int		(*open)		(struct pwmtach_core_s *core, u_int new_use_count);
    void	(*release)	(struct pwmtach_core_s *core, u_int new_use_count);

    int		(*tach_get_rpm)	(struct pwmtach_core_s *core, uint8_t index,
				 uint8_t pulses_per_rev, uint16_t *revs_per_minute);

    void        (*tach_activate_channel)(struct pwmtach_core_s *core, uint8_t index);
    
    int		(*pwm_set_freq) (struct pwmtach_core_s *core, uint8_t index, unsigned int freq);
    int		(*pwm_get_freq) (struct pwmtach_core_s *core, uint8_t index, unsigned int *freq);
    int		(*pwm_set_duty) (struct pwmtach_core_s *core, uint8_t index, uint8_t duty_cycle);
    int		(*pwm_get_duty) (struct pwmtach_core_s *core, uint8_t index, uint8_t *duty_cycle);

    /* alternate functions shared with pwm/tacho pins (optional) */
    u_char	(*pwm_get_alternate)	(struct pwmtach_core_s *core, uint8_t index);
    void	(*pwm_set_alternate)	(struct pwmtach_core_s *core, uint8_t index, u_char alternate);
    u_char	(*tach_get_alternate)	(struct pwmtach_core_s *core, uint8_t index);
    void	(*tach_set_alternate)	(struct pwmtach_core_s *core, uint8_t index, u_char alternate);

} pwmtach_core_t;

typedef int  (*core_init_fn_t)   (pwmtach_core_t *core, u_char core_nr);

#endif /* __PWMTACH_CORE_H__ */
