#ifndef __PP_TIMER_H
#define __PP_TIMER_H

/* high resolution timer support */

/* returns the ppc timebase register as
   long long value                       */
static unsigned long long ppc_timebase(void)
{
    unsigned long long t;
    unsigned long u, u0, l;
    do { // loop required as per PPC manual
	u0 = get_tbu();
	l = get_tbl();
	u = get_tbu();
    } while(u0 != u); // reread if rollover occurred
    t = ((unsigned long long)u << 32) | l;
    return t;
}

/* takes two timebase values and calculates the
   difference in nano seconds.
   We don't take care of wrap arounds and overflows */
static unsigned long long ppc_timediff_ns(unsigned long long t1,
					  unsigned long long t2)
{
    /* TODO, should be determined by boot code */
    unsigned long ppc_clockspeed = 200; /* in MHz */
    /* nano seconds per clock tick */
    unsigned long ppc_ns_per_tick = 1000 / ppc_clockspeed;
    unsigned long long tmp;
    if(t1 > t2) { tmp = t1; t1 = t2; t2 = tmp; }
    return (t2 - t1) * ppc_ns_per_tick;
}

#endif //__PP_TIMER_H
