#ifndef __ZERO_USB_H
#define __ZERO_USB_H

#define TRUE			1
#define FALSE			0

#define HIGHSPEED

//Full speed
#define PP_VENDOR_ID		0x14dd
#define PP_PRODUCT_ID		0X0002
#define PP_DEVICE_RELEASE_NO	0X0001
#define PP_CONFIGURATION_NUMBER	0X01

#define EP0_BUFSIZE		4096
#define BULK_EP_BUFLEN		16384

#include "chap9.h"
#include "pphid.h"

#define MAX_CONFIG_DESC_LEN	200

#define USB_DT_HID		(USB_TYPE_CLASS | 0x01)
#define USB_DT_HID_SIZE		9

enum zero_state {
	ZERO_STATE_IDLE,
	ZERO_STATE_INTERFACE_CHANGE,
	ZERO_STATE_CONFIG_CHANGE,
	ZERO_STATE_DISCONNECT,
	ZERO_STATE_EXIT,
	ZERO_STATE_TERMINATED
};

enum fsg_buffer_state {
	BUF_STATE_EMPTY = 0,
	BUF_STATE_FULL,
	BUF_STATE_BUSY
};

struct zero_buffhd {
	void				*buf;
	dma_addr_t			dma;
	volatile enum fsg_buffer_state	state;
	struct zero_buffhd		*next;

	/* The NetChip 2280 is faster, and handles some protocol faults
	 * better, if we don't submit any short bulk-out read requests.
	 * So we will record the intended request length here. */
	unsigned int			out_intended_length;

	struct usb_request		*inreq;
	volatile int			inreq_busy;
	struct usb_request		*outreq;
	volatile int			outreq_busy;
};

typedef struct {
    int (*vendor_device_request)(struct FTC_zero_dev *ZeroDev, const struct usb_ctrlrequest *ctrl);
    int (*class_interface_request[MAX_INTERFACES])(struct FTC_zero_dev *ZeroDev, const struct usb_ctrlrequest *ctrl);
} ftc_usb_driver_t;

//********************************************************************

/* USB device bit flags: */
#define REGISTERED		0

struct FTC_zero_dev;

typedef struct {
    struct usb_ep* ep;
    struct zero_buffhd *bufhd;
    struct FTC_zero_dev *dev;
    void (*complete)(struct usb_ep* ep);
    void* class_ep_data;
} ep_driver_t;

typedef struct {
    int used;
    char name[10];
    struct usb_ep** ep_ptr;
} eps_t;

struct ppstorage_intf_t;

struct FTC_zero_dev {
	spinlock_t		lock;
	unsigned long		atomic_bitflags;

	/* Character device minor number */
	int			minor;

	/* Low-level gadget driver register/unregister functions */
	int (*register_driver)(struct usb_gadget_driver *driver);
	int (*unregister_driver)(struct usb_gadget_driver *driver);

	/* Thread handling */
	struct task_struct	*thread_task;
	int			thread_pid;
	sigset_t		thread_signal_mask;
	struct completion	thread_notifier_start;
	struct completion	thread_notifier_exit;
	wait_queue_head_t	thread_wqh;
	volatile int		thread_wakeup_needed;

	/* Thread state */
	volatile enum zero_state state;
	unsigned int		exception_req_tag;

	/* Low-level driver data */
	struct usb_gadget	*gadget;
	eps_t			eps[16];
	u8			u8UsbConfigValue;
	u8			u8UsbInterfaceValue;
	u8			u8UsbInterfaceAlternateSetting;
	u8			config, new_config;
#if defined(PP_FEAT_USB_FORCE_FS)
	u8                      force_fs;     /* set by ioctl, passed down to low-level */
#endif

	/* EP0: Control requests */
	struct usb_ep		*ep0;
	struct usb_request	*ep0req;
	const char		*ep0req_name;
	volatile unsigned int	ep0_req_tag;

	/* HID */
	pphid_t			*hid;
	unsigned int		mouse_enabled;
	struct usb_ep		*mouse_ep;
	struct zero_buffhd	buffhds_mouse_intr_in;
	unsigned int		keyboard_enabled;
	struct usb_ep		*keyboard_ep;
	struct zero_buffhd	buffhds_keyboard_intr_in;

	/* Mass Storage */
	int                     ms_enabled;
	struct ppstorage_intf_t	*storage[PP_FEAT_USB_MASS_STORAGE_NO];
	unsigned int		bulk_out_maxpacket;

	/* Former global variables collected from various places */
	struct usb_gadget_strings stringtab;
	ftc_usb_driver_t        g_ud;
	uint8_t                 config_desc_hs[MAX_CONFIG_DESC_LEN];
	uint8_t                 config_desc_fs[MAX_CONFIG_DESC_LEN];
	int                     mass_storage_enabled[PP_FEAT_USB_MASS_STORAGE_NO];
	usb_device_type_t       mass_storage_type[PP_FEAT_USB_MASS_STORAGE_NO];
	int                     HID_MouseInterfaceNumber;
	int                     HID_KeyboardInterfaceNumber;
	volatile uint8_t        g_DeviceSuspended;
	char                    *mouse_report_descriptor;
	usb_device_t		usb_device_new;
	usb_device_t		usb_device;
	usb_device_kbd_type_t	usb_device_kbd_type_new;
	usb_device_kbd_type_t	usb_device_kbd_type;
	usb_device_mouse_type_t	usb_device_mouse_type_new;
	usb_device_mouse_type_t	usb_device_mouse_type;
	int			enable_mass_storage_new[PP_FEAT_USB_MASS_STORAGE_NO];
	int			enable_mass_storage[PP_FEAT_USB_MASS_STORAGE_NO];
	usb_device_type_t	mass_storage_types[PP_FEAT_USB_MASS_STORAGE_NO];
	char			pp_usb_serial[40];

	/* Descriptors; */
	struct usb_device_descriptor device_desc;
	struct usb_qualifier_descriptor dev_qualifier;
	struct usb_endpoint_descriptor mass_storage_bulk_in_desc[PP_FEAT_USB_MASS_STORAGE_NO];
	struct usb_endpoint_descriptor mass_storage_bulk_out_desc[PP_FEAT_USB_MASS_STORAGE_NO];
	USB_HID_DESCRIPTOR mouse_hid_desc;
	struct usb_endpoint_descriptor mouse_ep_desc_fs;
	struct usb_endpoint_descriptor mouse_ep_desc_hs;
	USB_HID_DESCRIPTOR keyboard_hid_desc;
	struct usb_endpoint_descriptor keyboard_ep_desc_fs;
	struct usb_endpoint_descriptor keyboard_ep_desc_hs;
};


/*------------------ device descriptor table define---------------------------------*/
/*
 * DESCRIPTORS ... most are static, but strings and (full) configuration
 * descriptors are built on demand.  Also the (static) config and interface
 * descriptors are adjusted during fsg_bind().
 */

/* There is only one configuration. */
#define	PP_CONFIG_VALUE		1

#define EP0_MAXPACKET		64

#define FS_BULK_IN_MAXPACKET	64
#define FS_BULK_OUT_MAXPACKET	64
#define FS_INTR_IN_MAXPACKET	64
#define FS_INTR_IN_MAXPACKET	64

#define HS_BULK_IN_MAXPACKET	512
#define HS_BULK_OUT_MAXPACKET	512
#define HS_INTR_IN_MAXPACKET	64
#define HS_INTR_IN_MAXPACKET	64

static const int MouseAbsReportLength = 6;
static const unsigned char  MouseReportDescriptorAbsolute[] = {
    0x05, 0x01,                    // USAGE_PAGE (Generic Desktop)
    0x09, 0x02,                    // USAGE (Mouse)
    0xa1, 0x01,                    // COLLECTION (Application)
    0x09, 0x01,                    //   USAGE (Pointer)
    0xa1, 0x00,                    //   COLLECTION (Physical)

    // buttons start
    0x05, 0x09,                    //     USAGE_PAGE (Button)
    0x19, 0x01,                    //     USAGE_MINIMUM (Button 1)
    0x29, 0x03,                    //     USAGE_MAXIMUM (Button 3)
    0x15, 0x00,                    //     LOGICAL_MINIMUM (0)
    0x25, 0x01,                    //     LOGICAL_MAXIMUM (1)
    0x95, 0x03,                    //     REPORT_COUNT (3)
    0x75, 0x01,                    //     REPORT_SIZE (1)
    0x81, 0x02,                    //     INPUT (Data,Var,Abs)
    0x95, 0x01,                    //     REPORT_COUNT (1)
    0x75, 0x05,                    //     REPORT_SIZE (5)
    0x81, 0x01,                    //     INPUT (Cnst,Ary,Abs)

    /* X and Y */
    0x05, 0x01,                    //     USAGE_PAGE (Generic Desktop)
    0x09, 0x30,                    //     USAGE (X)
    0x09, 0x31,                    //     USAGE (Y)
    0x16, 0x00, 0x00,                    //     LOGICAL_MINIMUM (-126)
    0x26, 0xff, 0x7f,                    //     LOGICAL_MAXIMUM (127)
    0x36, 0x00, 0x00,  // phys. min
    0x46, 0xFF, 0x7F,  // phys. min
    0x66, 0x00, 0x00,
    0x75, 0x10,                    //     REPORT_SIZE (10)
    0x95, 0x02,                    //     REPORT_COUNT (2)
    0x81, 0x22,                    //     INPUT (Data,Var,Abs)

    /* W */
    0x05, 0x01,                    //     USAGE_PAGE (Generic Desktop)
    0x09, 0x38,                    //     USAGE (Z)
    
    0x15, 0x81,                    //     LOGICAL_MINIMUM (-127)
    0x25, 0x7f,                    //     LOGICAL_MAXIMUM (127)
#if 1
    0x35, 0x81,                    //     PHYSICAL_MINIMUM (-127)
    0x45, 0x7f,                    //     PHYSICAL_MAXIMUM (127)
#endif
    0x75, 0x08,                    //     REPORT_SIZE (8)
    0x95, 0x01,                    //     REPORT_COUNT (1)
    0x81, 0x06,                    //     INPUT (Data,Var,Rel)

    0xc0,                          //   END_COLLECTION
    0xc0                           // END_COLLECTION
};

static const int MouseRelReportLength = 4;
static const unsigned char  MouseReportDescriptorRelative[] = {
    0x05, 0x01,                    // USAGE_PAGE (Generic Desktop)
    0x09, 0x02,                    // USAGE (Mouse)
    0xa1, 0x01,                    // COLLECTION (Application)
    0x09, 0x01,                    //   USAGE (Pointer)
    0xa1, 0x00,                    //   COLLECTION (Physical)

    // buttons start
    0x05, 0x09,                    //     USAGE_PAGE (Button)
    0x19, 0x01,                    //     USAGE_MINIMUM (Button 1)
    0x29, 0x03,                    //     USAGE_MAXIMUM (Button 3)
    0x15, 0x00,                    //     LOGICAL_MINIMUM (0)
    0x25, 0x01,                    //     LOGICAL_MAXIMUM (1)
    0x95, 0x03,                    //     REPORT_COUNT (3)
    0x75, 0x01,                    //     REPORT_SIZE (1)
    0x81, 0x02,                    //     INPUT (Data,Var,Abs)
    0x95, 0x01,                    //     REPORT_COUNT (1)
    0x75, 0x05,                    //     REPORT_SIZE (5)
    0x81, 0x03,                    //     INPUT (Cnst,Ary,Abs)

    /* X and Y */
    0x05, 0x01,                    //     USAGE_PAGE (Generic Desktop)
    0x09, 0x30,                    //     USAGE (X)
    0x09, 0x31,                    //     USAGE (Y)
    0x09, 0x38,                    //     USAGE (W)
    0x15, 0x81,                    //     LOGICAL_MINIMUM (-126)
    0x25, 0x7f,                    //     LOGICAL_MAXIMUM (127)
    0x75, 0x08,                    //     REPORT_SIZE (10)
    0x95, 0x03,                    //     REPORT_COUNT (2)
    0x81, 0x06,                    //     INPUT (Data,Var,Rel)
    0xc0,                          //   END_COLLECTION
    0xc0                           // END_COLLECTION
};

static const unsigned char KeyboardReportDescriptor[] = {
    0x05, 0x01,                    // USAGE_PAGE (Generic Desktop)
    0x09, 0x06,                    // USAGE (Keyboard)
    0xa1, 0x01,                    // COLLECTION (Application)

    /* modifier keys */
    0x05, 0x07,                    //   USAGE_PAGE (Keyboard)
    0x19, 0xe0,                    //   USAGE_MINIMUM (Keyboard LeftControl)
    0x29, 0xe7,                    //   USAGE_MAXIMUM (Keyboard Right GUI)
    0x15, 0x00,                    //   LOGICAL_MINIMUM (0)
    0x25, 0x01,                    //   LOGICAL_MAXIMUM (1)
    0x75, 0x01,                    //   REPORT_SIZE (1)
    0x95, 0x08,                    //   REPORT_COUNT (8)
    0x81, 0x02,                    //   INPUT (Data,Var,Abs)
    0x95, 0x01,                    //   REPORT_COUNT (1)
    0x75, 0x08,                    //   REPORT_SIZE (8)
    0x81, 0x01,                    //   INPUT (Cnst,Ary,Abs)

    /* normal keys */
    0x19, 0x00,                    //   USAGE_MINIMUM (Reserved (no event indicated))
    0x29, 0xe7,                    //   USAGE_MAXIMUM (Keyboard Right GUI)
    0x15, 0x00,                    //   LOGICAL_MINIMUM (0)
    0x26, 0xe7, 0x00,              //   LOGICAL_MAXIMUM (231)
    0x75, 0x08,                    //   REPORT_SIZE (8)
    0x95, 0x06,                    //   REPORT_COUNT (6)
    0x81, 0x00,                    //   INPUT (Data,Ary,Abs)

    /* LEDs */
    0x05, 0x08,                    //   USAGE_PAGE (LEDs)
    0x19, 0x01,                    //   USAGE_MINIMUM (Num Lock)
    0x29, 0x05,                    //   USAGE_MAXIMUM (Kana)
    0x15, 0x00,                    //   LOGICAL_MINIMUM (0)
    0x25, 0x01,                    //   LOGICAL_MAXIMUM (1)
    0x75, 0x01,                    //   REPORT_SIZE (1)
    0x95, 0x05,                    //   REPORT_COUNT (5)
    0x91, 0x02,                    //   OUTPUT (Data,Var,Abs)
    0x95, 0x01,                    //   REPORT_COUNT (1)
    0x75, 0x03,                    //   REPORT_SIZE (3)
    0x91, 0x01,                    //   OUTPUT (Cnst,Ary,Abs)
    0xc0                           // END_COLLECTION
};

/* Maxpacket and other transfer characteristics vary by speed. */
#define ep_desc(g,fs,hs)	(((g)->speed==USB_SPEED_HIGH) ? (hs) : (fs))
#define ep_set_speed(g,d,fssize,hssize)       (d->wMaxPacketSize = ((g)->speed==USB_SPEED_HIGH)?hssize:fssize)

#define USB_ZERO_BUFSIZ	4096
#define DELAYED_STATUS	(EP0_BUFSIZE + 999)	// An impossibly large value

void start_transfer(struct FTC_zero_dev*ZeroDev, struct usb_ep *ep,
		    struct usb_request *req, volatile int *pbusy, volatile enum fsg_buffer_state *state);
int zero_wait_for_buf_free(struct FTC_zero_dev *zero_dev, struct zero_buffhd *bh);
int zero_wait_for_buf_full(struct FTC_zero_dev *zero_dev, struct zero_buffhd *bh);
void raise_exception(struct FTC_zero_dev *ZeroDev, enum zero_state new_state);
int populate_config_buf(struct FTC_zero_dev *ZeroDev, enum usb_device_speed speed,u8 *buf0, u8 type, unsigned index);
int zero_set_halt(struct FTC_zero_dev*ZeroDev, struct usb_ep *ep);
int ep0_queue(struct FTC_zero_dev *ZeroDev);

#endif /* __ZERO_USB_H  */
