#ifndef _KERNEL_USB_H
#define _KERNEL_USB_H

typedef enum {
    PP_USB_DEVSTAT_ERROR = 0,
    PP_USB_DEVSTAT_ATTACHED = 1,
    PP_USB_DEVSTAT_POWERED = 2,
    PP_USB_DEVSTAT_SUSPENDED = 3,
    PP_USB_DEVSTAT_DEFAULT = 4,
    PP_USB_DEVSTAT_ADDRESS = 5,
    PP_USB_DEVSTAT_CONFIGURED = 6
} usb_device_state_t;

typedef enum {
    usb_device_none,
    usb_device_unchanged,
    usb_device_peppercon,
    usb_device_ripcbelkin
} usb_device_t;

typedef enum {
    usb_device_kbd_unchanged = 0,
    usb_device_kbd_none,
    usb_device_kbd_enabled
} usb_device_kbd_type_t;

typedef enum {
    peppercon_mouse_type_none,
    peppercon_mouse_type_unchanged,
    peppercon_mouse_type_relative,
    peppercon_mouse_type_absolute
} usb_device_mouse_type_t;

typedef enum {
    usb_device_ms_unchanged = 0,
    usb_device_ms_disabled,
    usb_device_ms_enabled
} usb_device_ms_t;

typedef enum {
    PP_USB_IMAGE_TYPE_NONE = 0,
    PP_USB_IMAGE_TYPE_REMOVABLE,
    PP_USB_IMAGE_TYPE_FLOPPY,
    PP_USB_IMAGE_TYPE_FIXED,
    PP_USB_IMAGE_TYPE_ISO
} usb_device_type_t;

typedef struct {
    u_int8_t channel;
    u_int8_t type;
    u_int16_t length;
} lara_usb_command_t;

#define PP_USB_MAX_HID_DATA_LEN 64

typedef struct {
    lara_usb_command_t command;
    u_int8_t data[PP_USB_MAX_HID_DATA_LEN];
} cmd_struct_t;

typedef struct {
    usb_device_t dev;
    usb_device_kbd_type_t keyboard_type; // ignored on PPC
    usb_device_mouse_type_t mouse_type;
    usb_device_ms_t mass_storage[PP_FEAT_USB_MASS_STORAGE_NO];
} lara_usb_device_t;

typedef enum {
    PP_USB_NOTHING,
    PP_USB_READ,
    PP_USB_WRITE,
    PP_USB_WRITE_DONE,
    PP_USB_SETUP_PROTO_REQ,
    PP_USB_SETUP_PROTO_REQ_DONE,
    PP_USB_SETUP_PROTO_RSP
} lara_usb_scsi_data_cmd_t;

typedef struct {
    lara_usb_scsi_data_cmd_t cmd;
    u_int32_t id;
    u_int32_t block_length;
    u_int32_t block_address;
    u_int16_t length;
} file_request_t;

typedef struct {
    u_int32_t dev_no;
    file_request_t request;
} file_request_control_t;

typedef struct {
    u_int32_t dev_no;
    u_int8_t response;
    u_int32_t length;
    u_int8_t* data;
} file_response_t;

#define MAXUSBFILENAMELEN 512

typedef struct {
    u_int32_t dev_no;
    u_int32_t lba;
    u_int32_t blocklen;
    usb_device_type_t image_type;
    u_int8_t readonly;
    char filename[MAXUSBFILENAMELEN+1];
} file_info_t;

typedef enum {
    PP_KVM_PORT_CHANGED,
    PP_KVM_DEVICE_STATUS,
    PP_KVM_CONSOLE_BEEP,
    PP_KVM_AUTOSCAN,
    PP_KVM_IP_ADDRESS,
    PP_KVM_LED_CHANGE,
    PP_KVM_SET_UNIT_HOSTS
} usb_usrspace_function_id;

typedef struct {
    u_int8_t function;
    union {
	struct {
	    u_int8_t channel;
	    u_int8_t old_bank;
	    u_int8_t old_host;
	    u_int8_t new_bank;
	    u_int8_t new_host;
	    u_int8_t control;
	} pp_kvm_port_changed_data;
	struct {
	    u_int8_t  channel;
	    u_int16_t status;
	} pp_kvm_device_status_data;
	struct {
	    u_int8_t channel;
	    u_int16_t pitch;
	    u_int8_t time;
	} pp_kvm_console_beep_data;
	struct {
	    u_int8_t channel;
	    u_int16_t status;
	} pp_kvm_autoscan_data;
	struct {
	    u_int32_t ip;
	    u_int32_t mask;
	    u_int32_t gw;
	    u_int8_t valid;
	} pp_kvm_ip_address_data;
	struct {
	    u_int8_t channel;
	    u_int8_t scroll_lock;
	    u_int8_t num_lock;
	    u_int8_t caps_lock;
	} pp_kvm_led_change_data;
	struct {
	    u_int16_t unit;
	    int16_t hosts;
	} pp_kvm_set_unit_hosts_data;
    } arguments;
} usb_usrspace_data_t;

typedef enum {
    PP_KM_INPUT_MOUSE,
    PP_KM_INPUT_KEYBOARD
} input_t;

#define KVM_IP_ADDRESS_VALID_IP 1
#define KVM_IP_ADDRESS_VALID_MASK 2
#define KVM_IP_ADDRESS_VALID_GW 4

#define FILE_DATA_OK        0
#define FILE_DATA_BAD       1
#define FILE_DATA_OK_SHORT  2

#define LARAUSBRESET                _IO   ('u',  1)
#define LARAUSBSENDDATA             _IOW  ('u',  3, lara_usb_command_t)
#define LARAUSBSETDEVICE            _IOW  ('u',  4, lara_usb_device_t)
#define LARAUSBGETDEVICESTATE       _IOR  ('u',  5, usb_device_state_t)
#define LARAUSBGETREQUEST           _IOWR ('u',  6, file_request_control_t)
#define LARAUSBSETRESPONSE          _IOW  ('u',  7, file_response_t)
#define LARAUSBSETFILE              _IOW  ('u',  8, file_info_t)
#define LARAUSBENABLESETUPPROTO     _IOW  ('u',  9, u_int8_t)
#define LARAUSBGETBELKIN	    _IOW  ('u', 10, usb_usrspace_data_t)
#define LARAUSBGETLEDSTATE          _IOR  ('u', 11, uint8_t)
#define LARAUSBSETFORCEFS           _IOW  ('u', 12, uint8_t)
#define LARAUSBHASFORCEFS           _IOR  ('u', 13, uint8_t)

#endif /* _KERNEL_USB_H */
