
#include <linux/config.h>
#include <asm/uaccess.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/smp_lock.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/timer.h>
#include <linux/list.h>
#include <linux/interrupt.h>
#include <linux/uts.h>
#include <linux/version.h>

#include <asm/byteorder.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/system.h>
#include <asm/unaligned.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
# include <linux/device.h>
#endif

#include <linux/usb_ch9.h>
#include <linux/usb_gadget.h>

#include "pp_usb_strings.h"

/* please note that these strings are in UTF-8, the gadget backend will converet it
   to UTF-16 */

const char shortname [] = 	"pp_usb_gadget";
const char longname [] = 	"Peppercon USB Gadget driver";

static const struct usb_string default_strings[] = {
#ifdef PRODUCT_MSIDC
    { 1, "MSI "},
#elif defined(OEM_INTEL)
    { Dev_iManufacturer, "Intel(R)"},
#elif defined(OEM_LENOVO)
    { Dev_iManufacturer, "Lenovo"},
#else
    { Dev_iManufacturer, "Peppercon AG"},
#endif
    { Dev_iProduct, "Multidevice" },
    { Dev_iSerialNumber, "12345678901234567890123456789012"},
    { 0, NULL}			// end of list
};

struct usb_string *pp_usb_strings_new()
{
    struct usb_string *strings;
    strings = kmalloc(sizeof(default_strings), GFP_KERNEL);
    memcpy(strings, default_strings, sizeof(default_strings));
    return strings;
}

void pp_usb_strings_delete(struct usb_string *strings)
{
    kfree(strings);
}

