#ifndef __PP_SCSI_H_
#define __PP_SCSI_H_

#include "usb-mass-storage-bot.h"
#ifdef __arm__
# include "ppstorage.h"
#else
# include "mass-storage-bo.h"
#endif

extern volatile uint8_t scsi_setup_proto_enabled;

struct scsi_s *scsi_new(int index);
void scsi_free(struct scsi_s *scsi);

void scsi_set_file(struct scsi_s *scsi, uint32_t lba, uint32_t blocklen, usb_device_type_t type, uint8_t readonly);

uint8_t scsi_handler(bot_t * bot, uint8_t* cbwcb, uint8_t cbwcb_len,
		     uint32_t data_len_req, transfer_phase_t trans_dir_in,
		     uint8_t ** buf, transfer_phase_t* data_phase, uint32_t* data_len);

void scsi_reset(struct scsi_s *scsi);

#endif /* #ifndef __PP_SCSI_H_ */

