#ifndef _LIBERIC_CERT_H
#define _LIBERIC_CERT_H

#define ERIC_CERT_DIR		   "/etc/e-RIC/ssl/"

#define ERIC_CERT_CFG_FILENAME	   "openssl.cnf"
#define ERIC_CERT_CFGHDR_FILENAME  "openssl.cnf.hdr"
#define ERIC_CERT_DEFKEY_FILENAME  "erickey_default.pem"
#define ERIC_CERT_USRKEY_FILENAME  "erickey_user.pem"
#define ERIC_CERT_NEWKEY_FILENAME  "erickey_new.pem"
#define ERIC_CERT_DEFCERT_FILENAME "ericcert_default.pem"
#define ERIC_CERT_USRCERT_FILENAME "ericcert_user.pem"
#define ERIC_CERT_NEWCERT_FILENAME "ericcert_new.pem"
#define ERIC_CERT_CSR_FILENAME	   "csr.txt"

#define ERIC_CERT_CFG_FILEPATH	   ERIC_CERT_DIR ERIC_CERT_CFG_FILENAME
#define ERIC_CERT_CFGHDR_FILEPATH  ERIC_CERT_DIR ERIC_CERT_CFGHDR_FILENAME
#define ERIC_CERT_DEFKEY_FILEPATH  ERIC_CERT_DIR ERIC_CERT_DEFKEY_FILENAME
#define ERIC_CERT_USRKEY_FILEPATH  ERIC_CERT_DIR ERIC_CERT_USRKEY_FILENAME
#define ERIC_CERT_NEWKEY_FILEPATH  ERIC_CERT_DIR ERIC_CERT_NEWKEY_FILENAME
#define ERIC_CERT_DEFCERT_FILEPATH ERIC_CERT_DIR ERIC_CERT_DEFCERT_FILENAME
#define ERIC_CERT_USRCERT_FILEPATH ERIC_CERT_DIR ERIC_CERT_USRCERT_FILENAME
#define ERIC_CERT_NEWCERT_FILEPATH ERIC_CERT_DIR ERIC_CERT_NEWCERT_FILENAME
#define ERIC_CERT_CSR_FILEPATH	   ERIC_CERT_DIR ERIC_CERT_CSR_FILENAME

#define ERIC_CERT_ERR_NO_ERROR		0
#define ERIC_CERT_ERR_INTERNAL_ERROR	1
#define ERIC_CERT_ERR_NO_PENDING_CERT	2
#define ERIC_CERT_ERR_CERT_NOT_MATCHING	3
#define ERIC_CERT_ERR_CERT_FORMAT_WRONG 4

#define ERIC_CERT_MIN_KEY_LENGTH	1024
#define ERIC_CERT_MAX_KEY_LENGTH	2048

#define ERIC_CERT_MAX_FILESIZE		(16*1024)

#include <sys/types.h>

typedef struct {
    char * c;
    char * st;
    char * l;
    char * o;
    char * ou;
    char * cn;
    char * email;
} eric_cert_info_t;

extern int eric_cert_init(void);
extern void eric_cert_cleanup(void);
const char * eric_cert_get_error_string(const int error);

/* create key and certificate signing request (CSR) */
extern void eric_cert_create_key(const char * c, const char * st,
				 const char * l, const char * o,
				 const char * ou, const char * cn,
				 const char * email, const char * challenge,
				 unsigned int bits, int * error);

/* delete key and CSR */
extern void eric_cert_delete_key(int * error);

/* get CSR data */
extern void eric_cert_get_csr(void * csr_data_p, size_t * csr_data_size_p,
			      int * error);

/* get CSR info */
extern void eric_cert_get_csr_info(char * info_buf, size_t info_buf_size,
				   int * error);

/* install certificate */
extern void eric_cert_install(const void * cert_data, size_t cert_data_size,
			      int * error);

#endif /* _LIBERIC_CERT_H */
