#ifndef _LIBERIC_CONFIG_H
#define _LIBERIC_CONFIG_H

#ifdef __cplusplus
extern "C" {
#endif

#include <pthread.h>
#include <stdarg.h>
#include <time.h>
#include <sys/types.h>
#include <stdio.h>

#define MAX_OPT_KEY_LEN		128
#define MAX_OPT_VALUE_LEN	2048

typedef struct {
    char * key;
    char * value;
} eric_config_option_t;

typedef enum { FLUSH_IN_FOREGROUND, FLUSH_IN_BACKGROUND } flush_type_t;

union semun {
    int val;                  /* value for SETVAL */
    struct semid_ds *buf;     /* buffer for IPC_STAT, IPC_SET */
    unsigned short *array;    /* array for GETALL, SETALL */
    /* Linux specific part: */
    struct seminfo *__buf;    /* buffer for IPC_INFO */
};

typedef void (*for_each_option_cb_t)(eric_config_option_t *, va_list);
typedef void (*for_all_files_cb_t)(const char *, va_list);

extern pthread_mutex_t eric_config_flash_write_mtx;
extern int eric_config_ext_change_sem_id;
extern int eric_config_ext_change_ntfy;

eric_config_option_t* eric_config_option_create(const char* key,
						const char* value);
void eric_config_option_destroy(void* opt);

int eric_config_init(flush_type_t _flush_type);
void eric_config_cleanup(void);

int eric_config_file_changed_since(const char * name, time_t * mtime);
void eric_config_install_defaults(void);
int eric_config_file_write(const char * name,
				  eric_config_option_t ** options,
				  int create);
int eric_config_file_write_core(const char * name,
	   	                eric_config_option_t ** options,
                                int create, int lock);
int eric_config_file_write_nucleus(const char * name,
	   	                   eric_config_option_t ** options,
                                   int create, int lock);
int eric_config_file_delete(const char * name);
int eric_config_file_copy(const char *name, const char *dest);
int eric_config_file_replace(const char *name, const char *src);
int eric_config_file_replace_and_reboot(const char *name, const char *src);
int eric_config_parse_line(char *ln, char **key, char **value, 
                                  FILE * fp, int line, const char *filepath);
int eric_config_file_for_each_option(const char * name,
					    for_each_option_cb_t cb, ...);
int eric_config_for_all_files(for_all_files_cb_t cb, ...);
int eric_config_flush(void);
void eric_config_flush_in_foreground(void);
void eric_config_avoid_flushing(int avoid);

int eric_config_set_flush_lock(void);
int eric_config_set_flush_lock_no_undo(void);
int eric_config_release_flush_lock(void);
int eric_config_release_flush_lock_no_undo(void);

int eric_config_ext_changed(void);

#ifdef __cplusplus
}
#endif

#endif /* _LIBERIC_CONFIG_H */
