#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include <pp/base.h>
#include <pp/cfg.h>
#include <liberic_notify.h>
#include <liberic_misc.h>
#if defined(PP_FEAT_REMOTE_CONSOLE)
#include <pp/km.h>
#include <pp/vsc.h>
#endif
#if defined(PP_FEAT_AD_ATMEL) || defined(PP_FEAT_PCI_ADC)
#  include <pp/sense.h>
#endif

int
eric_misc_get_host_power(int * host_power)
{

#if defined(PP_FEAT_REMOTE_CONSOLE)

#if defined(PP_FEAT_AD_ATMEL) || defined(PP_FEAT_PCI_ADC)
    /* check PCI 12V line */
    float voltage;
    if (PP_FAILED(pp_sense_read_adc_value_raw(&voltage, PCI_VOLTAGE_12V))) {
	return -1;
    } else {
	*host_power = voltage>10? 1 : 0;
	return 0;
    }

#else

    video_signal_state_t signal;

    /* first check if we can ping kme */
    *host_power = pp_km_comm_proto_ping(0, NULL);
    if (*host_power == 0) {
	return 0;
    }

    /* if it seems to be powered on,
       look if we have a monitor signal */
    signal = pp_vsc_has_signal(0);

    switch(signal) {
      case VIDEO_SIGNAL_ON:
	  *host_power = 1;
	  return 0;
      case VIDEO_SIGNAL_OFF:
	  /* look further below */
	  break;
      case VIDEO_SIGNAL_UNKNOWN:
	  return -1;
    }

#endif
#endif /* PP_FEAT_REMOTE_CONSOLE */

    *host_power = 0;
    return 0;
}

int
eric_misc_get_host_pwrsupplypower(int * host_pwrsupply_power)
{

#if defined(PP_FEAT_REMOTE_CONSOLE)

#if defined(PP_FEAT_AD_ATMEL) || defined(PP_FEAT_PCI_ADC)

    float voltage;
    if (PP_FAILED(pp_sense_read_adc_value_raw(&voltage, PCI_VOLTAGE_3V_AUX))) {
	return PP_ERR;
    } else {
	*host_pwrsupply_power = (voltage>2) ? 1 : 0;
	return PP_SUC;
    }

#else
    (void)host_pwrsupply_power;
    return PP_ERR;

#endif
#else
    (void)host_pwrsupply_power;
    return PP_ERR;
    
#endif /* PP_FEAT_REMOTE_CONSOLE */
}
