#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <assert.h>
#include <unistd.h>
#include <sys/reboot.h>
#include <semaphore.h>

#include <pp/base.h>
#include <liberic_term.h>
#include <liberic_pthread.h>
#include <liberic_net.h>
#include <openssl/bio.h>
#include <pp/bio.h>

#include <term_internal.h>

static void client_cleanup_handler(void *);

void
eric_term_handle_connection(pp_net_conn_data_t * conn_data)
{
    term_cl_t * clp;
    int close_in_cleanup = 0;

    /* ---- allocate client structure ---------------------------------- */

    if ((clp = (term_cl_t *)calloc(1, sizeof(*clp))) == NULL) {
	pp_log_err("%s(): malloc()", ___F);
	goto fail;
    }

    pthread_cleanup_push(client_cleanup_handler, clp);
    close_in_cleanup = 1;

    /* ---- initialize client structure -------------------------------- */

    clp->conn_data = conn_data;

    if ((clp->net_fd = BIO_get_fd(conn_data->bio, NULL)) >= 0) {
	pp_bio_get_peer_name(conn_data->bio, clp->client_ip, sizeof(clp->client_ip));
    
	pp_log("Telnet connection from client %s\n", clp->client_ip);

	clp->loginp = clp->login;
	clp->passwdp = clp->passwd;
	clp->netip = clp->netibuf;
	clp->subpointer = clp->subbuffer;
	clp->subend = clp->subbuffer;
	clp->argv = clp->argptrfld;
	strcpy(clp->ArgStrLine, "");
	clp->last_attrib = 0x100; /* no last attrib */
	clp->cursor_visible = 1;
#ifdef PP_FEAT_CLP
	clp->clp_enabled = 1;
	clp->clp_session = NULL;
#endif
	clp->serial_id = conn_data->port_offset;
#ifdef PRODUCT_ICPMMD
	/* HACK: hide the two processor serial */
	clp->serial_id += 2;
#endif
	clp->serial_fd = -1;
	start_telnet(clp);
    } else {
	pp_log("%s(): BIO not initialized.\n", ___F);
    }

    pthread_cleanup_pop(1);
    clp = NULL; /* freed in cleanup handler */
 fail:
    if (!close_in_cleanup) {
	BIO_free_all(conn_data->bio);
	free(conn_data);
    }
    free(clp);
}

static void
client_cleanup_handler(void * _clp)
{
    term_cl_t * clp = (term_cl_t *)_clp;

    pp_log("telnet reader cleanup ...\n");

    serial_detach_client(clp);

    if (clp->session) eric_session_release(clp->session);

    BIO_free_all(clp->conn_data->bio);

    pp_log("Connection to client %s closed.\n", clp->client_ip);
    free(clp->conn_data);
    free(clp);
    pp_log("... telnet reader cleanup done.\n");
}
