#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include <terminal.h>
#include "commands.h"

/* this can stay as a global I think */
static struct command AppCmds[] = {
    {"version",         NULL, CmdVersion,    CmdVersionHelp},
# if !defined(PRODUCT_ASMIDC)
    {"terminal",        NULL, CmdTerminal,   CmdTerminalHelp},
# endif
# if (defined(PRODUCT_ERIC2) || defined(PRODUCT_ERICXP) || defined(PRODUCT_ERICG4)) && defined(PP_FEAT_POWERSWITCH)
    {"reset",           NULL, CmdReset,      CmdResetHelp},
    {"power",           NULL, CmdPower,      CmdPowerHelp},
# endif /* (PRODUCT_ERIC2 || PRODUCT_ERICXP || PRODUCT_ERICXPA) && PP_FEAT_POWERSWITCH */
# if defined(PP_FEAT_TELNET_KVM_PSWITCH)
    {"powerswitch",     NULL, CmdKVMPSwitch, CmdKVMPSwitchHelp},
# endif
# if defined(PP_FEAT_CLP)
    {"clp",		NULL, CmdClp,	CmdClpHelp}, 
# endif
# if defined(PP_FEAT_PCI_ADC) || defined(PP_FEAT_AD_ATMEL)
    {"voltages",	NULL, CmdVoltages, CmdVoltagesHelp}, 
# endif
};

void
add_eric_cmds(term_cl_t * clp)
{
    unsigned int i;

    for (i = 0; i < sizeof(AppCmds) / sizeof(struct command); i++) {
	term_insert_command(&AppCmds[i], clp);
    }
}

void
remove_eric_cmds(term_cl_t * clp)
{
    unsigned int i;

    for (i = 0; i < sizeof(AppCmds) / sizeof(struct command); i++) {
	term_remove_command(&AppCmds[i], clp);
    }
}
