#include <pp/base.h>
#include "keycodes.h"

static const unsigned char asc2key_us_map[128][5] = {
    /* 0x00 */	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
    /* 0x01 - 0x001a - Ctrl + Character */
    /* 0x01 */	{ 0xB6, 0x9d, 0x1d, 0x36, 0xFF }, 
    /* 0x02 */	{ 0xB6, 0xaf, 0x2f, 0x36, 0xFF }, 
    /* 0x03 */	{ 0xB6, 0xad, 0x2d, 0x36, 0xFF }, 
    /* 0x04 */	{ 0xB6, 0x9f, 0x1f, 0x36, 0xFF }, 
    /* 0x05 */	{ 0xB6, 0x91, 0x11, 0x36, 0xFF }, 
    /* 0x06 */	{ 0xB6, 0xa0, 0x20, 0x36, 0xFF }, 
    /* 0x07 */	{ 0xB6, 0xa1, 0x21, 0x36, 0xFF }, 
    /* 0x08 */	{ 0x8d, 0x0d, 0xFF, 0xFF, 0xFF }, /* BS */
    /* 0x09 */	{ 0x8e, 0x0e, 0xFF, 0xFF, 0xFF }, /* TAB */
    /* 0x0a */	{ 0xB6, 0xa3, 0x23, 0x36, 0xFF },
    /* 0x0b */	{ 0xB6, 0xa4, 0x24, 0x36, 0xFF }, 
    /* 0x0c */	{ 0xB6, 0xa5, 0x25, 0x36, 0xFF }, 
    /* 0x0d */	{ 0x9b, 0x1b, 0xFF, 0xFF, 0xFF }, /* Enter */
    /* 0x0e */	{ 0xB6, 0xb0, 0x30, 0x36, 0xFF }, 
    /* 0x0f */	{ 0xB6, 0x97, 0x17, 0x36, 0xFF }, 
    /* 0x10 */	{ 0xB6, 0x98, 0x18, 0x36, 0xFF }, 
    /* 0x11 */	{ 0xB6, 0x8F, 0x0F, 0x36, 0xFF }, 
    /* 0x12 */	{ 0xB6, 0x92, 0x12, 0x36, 0xFF }, 
    /* 0x13 */	{ 0xB6, 0x9e, 0x1e, 0x36, 0xFF }, 
    /* 0x14 */	{ 0xB6, 0x93, 0x13, 0x36, 0xFF }, 
    /* 0x15 */	{ 0xB6, 0x95, 0x15, 0x36, 0xFF }, 
    /* 0x16 */	{ 0xB6, 0xad, 0x2d, 0x36, 0xFF }, 
    /* 0x17 */	{ 0xB6, 0x90, 0x10, 0x36, 0xFF }, 
    /* 0x18 */	{ 0xB6, 0xac, 0x2c, 0x36, 0xFF }, 
    /* 0x19 */	{ 0xB6, 0x94, 0x14, 0x36, 0xFF }, 
    /* 0x1a */	{ 0xB6, 0xab, 0x2b, 0x36, 0xFF }, 
    /* 0x1b */	{ 0xbb, 0x3b, 0xFF, 0xFF, 0xFF }, /* ESC */
    /* 0x1c - 0x001f - dummies - ??? */
    /* 0x1c */	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, 
    /* 0x1d */	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, 
    /* 0x1e */	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, 
    /* 0x1f */	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, 
    /* 0x20 - 0x007f - printable characters */
    /* 0x20 */	{ 0xb8, 0x38, 0xFF, 0xFF, 0xFF }, /* SPC */ 
    /* Shift + Number */
    /* 0x21 */	{ 0xa9, 0x81, 0x01, 0x29, 0xFF }, 
    /* 0x22 */	{ 0xa9, 0x97, 0x27, 0x29, 0xFF }, 
    /* 0x23 */	{ 0xa9, 0x83, 0x03, 0x29, 0xFF }, 
    /* 0x24 */	{ 0xa9, 0x84, 0x04, 0x29, 0xFF }, 
    /* 0x25 */	{ 0xa9, 0x85, 0x05, 0x29, 0xFF }, 
    /* 0x26 */	{ 0xa9, 0x87, 0x07, 0x29, 0xFF }, 
    /* 0x27 */	{ 0x97, 0x27, 0xFF, 0xFF, 0xFF }, 
    /* 0x28 */	{ 0xa9, 0x89, 0x09, 0x29, 0xFF }, 
    /* 0x29 */	{ 0xa9, 0x8a, 0x0a, 0x29, 0xFF }, 
    /* 0x2a */	{ 0xa9, 0x87, 0x07, 0x29, 0xFF }, 
    /* 0x2b */	{ 0xa9, 0x8c, 0x0c, 0x29, 0xFF }, 
    /* 0x2c */	{ 0xb2, 0x32, 0xFF, 0xFF, 0xFF }, 
    /* 0x2d */	{ 0x8b, 0x0b, 0xFF, 0xFF, 0xFF }, 
    /* 0x2e */	{ 0xb3, 0x33, 0xFF, 0xFF, 0xFF }, 
    /* 0x2f */	{ 0xb4, 0x34, 0xFF, 0xFF, 0xFF }, 
    /* Numbers */
    /* 0x30 */	{ 0x8a, 0x0a, 0xFF, 0xFF, 0xFF }, 
    /* 0x31 */	{ 0x81, 0x01, 0xFF, 0xFF, 0xFF }, 
    /* 0x32 */	{ 0x82, 0x02, 0xFF, 0xFF, 0xFF }, 
    /* 0x33 */	{ 0x83, 0x03, 0xFF, 0xFF, 0xFF }, 
    /* 0x34 */	{ 0x84, 0x04, 0xFF, 0xFF, 0xFF }, 
    /* 0x35 */	{ 0x85, 0x05, 0xFF, 0xFF, 0xFF }, 
    /* 0x36 */	{ 0x86, 0x06, 0xFF, 0xFF, 0xFF }, 
    /* 0x37 */	{ 0x87, 0x07, 0xFF, 0xFF, 0xFF }, 
    /* 0x38 */	{ 0x88, 0x08, 0xFF, 0xFF, 0xFF }, 
    /* 0x39 */	{ 0x89, 0x09, 0xFF, 0xFF, 0xFF }, 
    /* 0x3a */	{ 0xa9, 0xa6, 0x26, 0x29, 0xFF }, 
    /* 0x3b */	{ 0xa6, 0x26, 0xFF, 0xFF, 0xFF }, 
    /* 0x3c */	{ 0xa9, 0xb2, 0x32, 0x29, 0xFF }, 
    /* 0x3d */	{ 0x8c, 0x0c, 0xFF, 0xFF, 0xFF }, 
    /* 0x3e */	{ 0xa9, 0xb3, 0x33, 0x29, 0xFF }, 
    /* 0x3f */	{ 0xa9, 0xb4, 0x34, 0x29, 0xFF }, 
    /* 0x40 */	{ 0xa9, 0x82, 0x02, 0x29, 0xFF }, 
    /* capital letters */
    /* 0x41 */	{ 0xa9, 0x9d, 0x1d, 0x29, 0xFF }, 
    /* 0x42 */	{ 0xa9, 0xaf, 0x2f, 0x29, 0xFF }, 
    /* 0x43 */	{ 0xa9, 0xad, 0x2d, 0x29, 0xFF }, 
    /* 0x44 */	{ 0xa9, 0x9f, 0x1f, 0x29, 0xFF }, 
    /* 0x45 */	{ 0xa9, 0x91, 0x11, 0x29, 0xFF }, 
    /* 0x46 */	{ 0xa9, 0xa0, 0x20, 0x29, 0xFF }, 
    /* 0x47 */	{ 0xa9, 0xa1, 0x21, 0x29, 0xFF }, 
    /* 0x48 */	{ 0xa9, 0xa2, 0x22, 0x29, 0xFF }, 
    /* 0x49 */	{ 0xa9, 0x96, 0x16, 0x29, 0xFF }, 
    /* 0x4a */	{ 0xa9, 0xa3, 0x23, 0x29, 0xFF }, 
    /* 0x4b */	{ 0xa9, 0xa4, 0x24, 0x29, 0xFF }, 
    /* 0x4c */	{ 0xa9, 0xa5, 0x25, 0x29, 0xFF }, 
    /* 0x4d */	{ 0xa9, 0xb1, 0x31, 0x29, 0xFF }, 
    /* 0x4e */	{ 0xa9, 0xb0, 0x30, 0x29, 0xFF }, 
    /* 0x4f */	{ 0xa9, 0x97, 0x17, 0x29, 0xFF }, 
    /* 0x50 */	{ 0xa9, 0x98, 0x18, 0x29, 0xFF }, 
    /* 0x51 */	{ 0xa9, 0x8f, 0x0f, 0x29, 0xFF }, 
    /* 0x52 */	{ 0xa9, 0x92, 0x12, 0x29, 0xFF }, 
    /* 0x53 */	{ 0xa9, 0x9e, 0x1e, 0x29, 0xFF }, 
    /* 0x54 */	{ 0xa9, 0x93, 0x13, 0x29, 0xFF }, 
    /* 0x55 */	{ 0xa9, 0x95, 0x15, 0x29, 0xFF }, 
    /* 0x56 */	{ 0xa9, 0xae, 0x2e, 0x29, 0xFF }, 
    /* 0x57 */	{ 0xa9, 0x90, 0x10, 0x29, 0xFF }, 
    /* 0x58 */	{ 0xa9, 0xac, 0x2c, 0x29, 0xFF }, 
    /* 0x59 */	{ 0xa9, 0x94, 0x14, 0x29, 0xFF }, 
    /* 0x5a */	{ 0xa9, 0xab, 0x2b, 0x29, 0xFF }, 
    /* some special characters */
    /* 0x5b */	{ 0x99, 0x19, 0xFF, 0xFF, 0xFF }, 
    /* 0x5c */	{ 0xa8, 0x28, 0xFF, 0xFF, 0xFF }, 
    /* 0x5d */	{ 0x9a, 0x1a, 0xFF, 0xFF, 0xFF }, 
    /* 0x5e */	{ 0xa9, 0x86, 0x06, 0x29, 0xFF }, 
    /* 0x5f */	{ 0xa9, 0x8b, 0x0b, 0x29, 0xFF }, 
    /* 0x60 */	{ 0x80, 0x00, 0xFF, 0xFF, 0xFF }, 
    /* small letters */
    /* 0x61 */	{ 0x9d, 0x1d, 0xFF, 0xFF, 0xFF }, 
    /* 0x62 */	{ 0xaf, 0x2f, 0xFF, 0xFF, 0xFF }, 
    /* 0x63 */	{ 0xad, 0x2d, 0xFF, 0xFF, 0xFF }, 
    /* 0x64 */	{ 0x9f, 0x1f, 0xFF, 0xFF, 0xFF }, 
    /* 0x65 */	{ 0x91, 0x11, 0xFF, 0xFF, 0xFF }, 
    /* 0x66 */	{ 0xa0, 0x20, 0xFF, 0xFF, 0xFF }, 
    /* 0x67 */	{ 0xa1, 0x21, 0xFF, 0xFF, 0xFF }, 
    /* 0x68 */	{ 0xa2, 0x22, 0xFF, 0xFF, 0xFF }, 
    /* 0x69 */	{ 0x96, 0x16, 0xFF, 0xFF, 0xFF }, 
    /* 0x6a */	{ 0xa3, 0x23, 0xFF, 0xFF, 0xFF }, 
    /* 0x6b */	{ 0xa4, 0x24, 0xFF, 0xFF, 0xFF }, 
    /* 0x6c */	{ 0xa5, 0x25, 0xFF, 0xFF, 0xFF }, 
    /* 0x6d */	{ 0xb1, 0x31, 0xFF, 0xFF, 0xFF }, 
    /* 0x6e */	{ 0xb0, 0x30, 0xFF, 0xFF, 0xFF }, 
    /* 0x6f */	{ 0x97, 0x17, 0xFF, 0xFF, 0xFF }, 
    /* 0x70 */	{ 0x98, 0x18, 0xFF, 0xFF, 0xFF }, 
    /* 0x71 */	{ 0x8f, 0x0f, 0xFF, 0xFF, 0xFF }, 
    /* 0x72 */	{ 0x92, 0x12, 0xFF, 0xFF, 0xFF }, 
    /* 0x73 */	{ 0x9e, 0x1e, 0xFF, 0xFF, 0xFF }, 
    /* 0x74 */	{ 0x93, 0x13, 0xFF, 0xFF, 0xFF }, 
    /* 0x75 */	{ 0x95, 0x15, 0xFF, 0xFF, 0xFF }, 
    /* 0x76 */	{ 0xae, 0x2e, 0xFF, 0xFF, 0xFF }, 
    /* 0x77 */	{ 0x90, 0x10, 0xFF, 0xFF, 0xFF }, 
    /* 0x78 */	{ 0xac, 0x2c, 0xFF, 0xFF, 0xFF }, 
    /* 0x79 */	{ 0x94, 0x14, 0xFF, 0xFF, 0xFF }, 
    /* 0x7a */	{ 0xab, 0x2b, 0xFF, 0xFF, 0xFF }, 
    /* some special characters */
    /* 0x7b */	{ 0xa9, 0x99, 0x19, 0x29, 0xFF }, 
    /* 0x7c */	{ 0xa9, 0xa8, 0x28, 0x29, 0xFF }, 
    /* 0x7d */	{ 0xa9, 0x9a, 0x1a, 0x29, 0xFF }, 
    /* 0x7e */	{ 0xa9, 0x80, 0x00, 0x29, 0xFF }, 
    /* 0x7f */	{ 0xce, 0x4e, 0xFF, 0xFF, 0xFF }  /* DEL */
};

static const unsigned char (* asc2key_maps[])[128][5] = {
    &asc2key_us_map
};

const unsigned char *
asc2key(term_cl_t * clp, unsigned int c)
{
    const unsigned char * asc2key_map;

    asc2key_map = (u_char *)asc2key_maps[clp->asc2key_map_id];
    return &asc2key_map[c*5];
}
