#include <pp/base.h>
#include <pp/dropbear.h>
#include <liberic_term.h>
#include <term_internal.h>

static int initialized = 0;

#ifdef PP_FEAT_TELNET
static u_short get_port_telnet(void);
#endif

#ifdef PP_FEAT_TERMINAL_SERVER
static u_short get_port_termsrv(void);
#endif

int
eric_term_init(void)
{
    if (!initialized) {
	if (PP_FAILED(serial_init())) {
	    return PP_ERR;
	}

#ifdef PP_FEAT_TELNET
	if (PP_FAILED(eric_net_register_proto(PP_NET_PROTOCOL_TYPE_TELNET, "TELNET", 1, get_port_telnet,
					      eric_net_init_bio_standard, eric_term_handle_connection))) {
	    goto error;
	}
#endif /* PP_FEAT_TELNET */

#ifdef PP_FEAT_TERMINAL_SERVER
	if (PP_FAILED(eric_net_register_proto(PP_NET_PROTOCOL_TYPE_TERMSRV, "TERMSRV",
# ifdef PRODUCT_ICPMMD
					      18,
# else /* !PRODUCT_ICPMMD */
					      2,
# endif /* !PRODUCT_ICPMMD */
					      get_port_termsrv,
					      eric_net_init_bio_standard, eric_term_handle_connection))) {
	    goto error;
	}
#endif /* PP_FEAT_TERMINAL_SERVER */

	initialized = 1;
    }

    return PP_SUC;

#if defined(PP_FEAT_TELNET) || defined(PP_FEAT_TERMINAL_SERVER)
 error:
    eric_net_unregister_proto(PP_NET_PROTOCOL_TYPE_TELNET);
    eric_net_unregister_proto(PP_NET_PROTOCOL_TYPE_TERMSRV);
#endif /* PP_FEAT_TELNET || PP_FEAT_TERMINAL_SERVER */
    serial_cleanup();
    return PP_ERR;
}

void
eric_term_cleanup(void)
{
    eric_net_unregister_proto(PP_NET_PROTOCOL_TYPE_TELNET);
    eric_net_unregister_proto(PP_NET_PROTOCOL_TYPE_TERMSRV);
    serial_cleanup();
    initialized = 0;
}

#ifdef PP_FEAT_TELNET
static u_short
get_port_telnet(void)
{
    int enabled;
    u_short port = 0;
    pp_cfg_is_enabled(&enabled, "network.telnet_enabled");
    if (enabled) pp_cfg_get_ushort(&port, "network.telnet_port");
    return port;
}
#endif /* PP_FEAT_TELNET */

#ifdef PP_FEAT_TERMINAL_SERVER
static u_short
get_port_termsrv(void)
{
    int enabled;
    u_short port = 0;
    pp_cfg_is_enabled(&enabled, "network.termsrv_enabled");
    if (enabled) pp_cfg_get_ushort(&port, "network.termsrv_baseport");
    return port;
}
#endif /* PP_FEAT_TERMINAL_SERVER */
