#ifndef _TERM_RING_BUF_H
#define _TERM_RING_BUF_H

#include <sys/types.h>

typedef struct {
    int on_heap;
    char * buf;
    size_t buf_size;
    u_int head_offs;
    u_int tail_offs;
    pthread_mutex_t lock;
    pthread_cond_t cond;
} ring_buf_t;

ring_buf_t * ring_buf_init(ring_buf_t * ring_buf, u_int buf_size);
void ring_buf_cleanup(ring_buf_t * ring_buf);

static inline int
ring_buf_empty(const ring_buf_t * ring_buf)
{
    return ring_buf->tail_offs == ring_buf->head_offs;
}

static inline int
ring_buf_full(const ring_buf_t * ring_buf)
{
    return (ring_buf->tail_offs + 1) % ring_buf->buf_size == ring_buf->head_offs;
}

static inline size_t
ring_buf_get_used_size(const ring_buf_t * ring_buf)
{
    return (ring_buf->tail_offs + ring_buf->buf_size - ring_buf->head_offs) % ring_buf->buf_size;
}

static inline size_t
ring_buf_get_free_size(const ring_buf_t * ring_buf)
{
    return (ring_buf->head_offs + ring_buf->buf_size - ring_buf->tail_offs - 1) % ring_buf->buf_size;
}


#endif /* _TERM_RING_BUF_H */
