/*
 * balloc.c -- Block allocation module
 *
 * moved to libpp_base
 * this is an adaptor for backward compatibility
 * tbr@peppercon.de
 */

/******************************** Includes ***********************************/

#include <pp/balloc.h>
#include <pp/mallocator.h>
#include "uemf.h"

static pp_mallocator_t* ballocator = NULL;

int
bopen(void *buf, int bufsize, int flags)
{
    ballocator = pp_bnew(buf, bufsize, flags);
    /* ballocator = pp_mallocator_heap(); */
    return 0;
}

/*
 * Close down the balloc module and free all malloced memory.
 */

void
bclose()
{
    pp_mallocator_destroy(ballocator);
    ballocator = NULL;
}

void *
balloc(B_ARGS_DEC, int size)
{
    return pp_malloc(ballocator, size);
}

void
bfree(B_ARGS_DEC, void *mp)
{
    pp_free(ballocator, mp);
}

void
bfreeSafe(B_ARGS_DEC, void *mp)
{
    pp_free(ballocator, mp);
}

/*
 * Duplicate an ascii string, allow NULL pointers and then dup an empty string.
 * If UNICODE, bstrdup above works with wide chars, so we need this routine
 * for ascii strings. 
 */
char *
bstrdup(B_ARGS_DEC, const char *s)
{
    if (s == NULL) {
	s = "";
    }
    return pp_strdup(ballocator, s);
}

void *
brealloc(B_ARGS_DEC, void *mp, int newsize)
{
    return pp_realloc(ballocator, mp, newsize);
}
