#ifndef _ERIC_BASE_H
#define _ERIC_BASE_H 1

#include <sys/types.h>
#include <stdio.h>
#include <liberic_notify.h>
#include <liberic_webs.h>
#include <liberic_session.h>
#include <pp/base.h>
#include <pp/firmware.h>
// really needed? #include <lara.h>

#define MAX_ERR_MSG_LEN		256
#define MAX_LABEL_LEN		256

struct _eric_webs_session_data_t {
    eric_session_int_id_t session;	/* the associated session */
    pp_firmware_ctx_t firmware_ctx;	/* the firmware context */
    void * vsc_data;			/* vsc upload data */
    size_t vsc_data_size;		/* size of vsc upload data */  
    void * oem_data;			/* oem upload data */
    size_t oem_data_size;		/* size of oem upload data */
    void * i18n_data;			/* i18n upload data */
    size_t i18n_data_size;		/* size of i18n upload data */
    void * fw_lang;			/* pointer to the firmware language update file */
    size_t fw_lang_size;		/* the real size of the firmware language update file */
    size_t fw_lang_alloc_size;		/* the allocated memory size for firmware language update file */
    void * ap_lang;			/* pointer to the applet language update file */
    size_t ap_lang_size;		/* the real size of the applet language update file */
    size_t ap_lang_alloc_size;		/* the allocated memory size for applet language update file */
    char * local_edit_tag;		/* active tag for profile editing */
    u_int log_list_page;		/* current page of log list */
    u_int sel_list_page;		/* current page of sel list */
    unsigned short screenshot_width;	/* width of the current screenshot */
    unsigned short screenshot_height;	/* height of the current screenshot */
};

int eric_init(void);
void eric_cleanup(void);

extern pp_hash_i_t* webs_session_data;
extern eric_webs_encoder_desc_t *encoder_hook;

#endif /* _ERIC_BASE_H */
