#!/bin/sh

source ../../Config.sh

TEMPLATE_FILES=tmpl_*.c

TEMPLATE_ALL_INITS=`cat ${TEMPLATE_FILES} | cpp ${FW_CPPFLAGS} | grep -E "[a-z_]+_tmpl_init" | perl -p -e 's,.*?([a-z_]+_tmpl_init).*,\1,'|sort -u`

cat > templates1.h <<EOF
#ifndef _TEMPLATES_H
#define _TEMPLATES_H

EOF

cat > templates.c <<EOF
#include "eric_forms.h"
#include "templates1.h"

typedef form_handler_t * (*form_handler_init_t)(void);

int
templates_init(void)
{
    int i;
    form_handler_init_t fh_init_routines[] = {
EOF

for init in ${TEMPLATE_ALL_INITS}; do
    name=${init%%_tmpl_init}
    if [ "${name}" = "${name%%_common}" ]; then
	name_upper=`echo ${name} | tr [:lower:] [:upper:]`
	echo "#define TEMPLATE_${name_upper} \"${name}\"" >> templates1.h
	echo "        ${init}," >> templates.c
	echo "extern form_handler_t * ${init}(void);" >> templates1.h
	echo >> templates1.h
    fi
done

echo "#endif /* _TEMPLATES_H */" >> templates1.h

cat >> templates.c <<EOF
        NULL
    };

    for (i = 0; fh_init_routines[i]; ++i) {
	form_handler_t * fh = fh_init_routines[i]();

	if (register_form_handler_instance(fh)) {
	    pp_log("%s(): %s\n", ___F, reg_form_handler_failed_msg);
	    return -1;
	}
    }

    return 0;
}
EOF
