#include <liberic_net.h>
#include "wsIntrn.h"
#include "webs.h"

/*
 * Check if EOF is reached on a BIO
 */

int webs_bio_eof(webs_t wp)
{
    char c;

    if (wp == NULL || wp->bio == NULL) {
	return -1;
    }

    return (recv(BIO_get_fd(wp->bio, NULL), &c, 1,MSG_DONTWAIT|MSG_PEEK) == 0);
}

/*
 * Perform a gets of the SSL BIO, returning an balloc'ed string
 *
 *   Get a string from a socket. This returns data in *buf in a malloced string
 *   after trimming the '\n'. If there is zero bytes returned, *buf will be set
 *   to NULL. If doing non-blocking I/O, it returns -1 for error, EOF or when
 *   no complete line yet read. If doing blocking I/O, it will block until an
 *   entire line is read. If a partial line is read socketInputBuffered or 
 *   socketEof can be used to distinguish between EOF and partial line still 
 *   buffered. This routine eats and ignores carriage returns.
 */

#define BUF_BLOCK 256

int webs_bio_gets(webs_t wp, char ** buf)
{
    int		len = 0;
    int		lenBuf = 0;
    int		rc;
    char	c;

    if (wp == NULL || wp->bio == NULL || buf == NULL) {
	return -1;
    } 

    while (1) {

	if ((rc = eric_net_read(wp->bio, &c, 1, 0)) < 0) {
	    /*
	     * If there is a partial line and we are at EOF,
	     * pretend we saw a '\n'
	     */
	    if (len > 0 && webs_bio_eof(wp)) {
		c = '\n';
	    } else {
		return rc;
	    }
	}
		
	/*
	 * If a newline is seen, return the data excluding the new
	 * line to the caller. If carriage return is seen, just eat it.
	 */
	if (c == '\n') {
	    if ((len > 0) && (len < lenBuf)) {
		(*buf)[len] = 0;
	    }
	    return len;
	} else if (c == '\r') {
	    continue;
	}
	/*
	 * Append character to buf
	 */
	if (len >= lenBuf) {
	    lenBuf += BUF_BLOCK;
	    *buf = brealloc(B_L, *buf, lenBuf);
	}

	a_assert(*buf);
	(*buf)[len] = c;
	len++;
    }
}

/*
 * Perform a read from a BIO
 */

int webs_bio_read_exact(webs_t wp, void * buf, size_t len)
{
    if (wp == NULL || wp->bio == NULL || buf == NULL) {
	return -1;
    } 

    return eric_net_read_exact(wp->bio, buf, len, 0);
}

/*
 * Perform a write to a BIO
 */

int webs_bio_write_exact(webs_t wp, const void * buf, size_t len)
{
    if (wp == NULL || wp->bio == NULL || buf == NULL) {
	return -1;
    } 

    return eric_net_write_exact(wp->bio, buf, len, 0);
}

/*
 * Closes a BIO
 */

void webs_bio_close(webs_t wp)
{
    eric_net_close(wp->bio, WAIT);
    wp->bio = NULL;
}
