#include <liberic_notify.h>
#include <pp/um.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "tmpl_acl_common.h"
#include "wsIntrn.h"
#include "tmpl_acl_common.h"

#ifdef PP_FEAT_PERM_MANAGEMENT

FV_SPEC = {
    {
	id:		FV_ID_ACL_PRINCIPAL_OBJECTS,
	cfgkey:		"device.perms[%I]",
	elemkey:	"object"
    },
    {
	id:		FV_ID_ACL_PRINCIPAL_OBJECT_PERMS,
	cfgkey:		"permvect[%I]",
    },
    {
        id:             FV_ID_ACL_PRINCIPAL_ACL,
        cfgkey:         "group[%G].acl[%S]",
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
acl_tmpl_init(void)
{
    form_handler_t * fh;

    if (acl_common_tmpl_init() != 0) return -1;
    
    fh = CREATE_FH_INSTANCE(TEMPLATE_ACL, ACL_OBJ_ACL);

    fh->pre_validate_hook = pre_validate_hook;
    fh->disable_ldap=TRUE;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
#if defined(PP_FEAT_RARITAN_STYLE_UM_PAGES)
    (void)wp;
    fh->fv[FV_ID_ACL_PRINCIPAL_OBJECTS].flags |= 
        FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    fh->fv[FV_ID_ACL_PRINCIPAL_OBJECT_PERMS].flags |= 
        FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
#else /* !PP_FEAT_RARITAN_STYLE_UM_PAGES */
    const char *user_select = websGetVar(wp, "__user_select__", NULL);
    const char *group_select = websGetVar(wp, "__group_select__", NULL);
    int user_changed = pp_strcmp_safe(wp->target_group, user_select);
    int group_changed = pp_strcmp_safe(wp->target_group, group_select);
    
    if(user_changed && user_select && *user_select) {
        /* the user select changed */
        bfreeSafe(B_L, wp->target_group);
        wp->target_group = bstrdup(B_L, user_select);
        wp->target_gid = pp_um_group_get_gid(wp->target_group);
    } else if(group_changed && group_select && *group_select) {
        bfreeSafe(B_L, wp->target_group);
        wp->target_group = bstrdup(B_L, group_select);
        wp->target_gid = pp_um_group_get_gid(wp->target_group);
    }
    websSetVar(wp, "__target_group__", wp->target_group);
    
    if (!form_button_clicked(wp, "action_apply")) {
	/* form not applied -> neighter validate nor save */
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
        /* FIXME: why do I have to delete form vars here?
                  without, permissions are not updated on target group switch */
        delete_form_vars(wp);
    } else {
        fh->fv[FV_ID_ACL_PRINCIPAL_OBJECTS].flags |= 
            FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
        fh->fv[FV_ID_ACL_PRINCIPAL_OBJECT_PERMS].flags |= 
            FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    }
#endif /* !PP_FEAT_RARITAN_STYLE_UM_PAGES */
        
    return 0;
}

#else /* PP_FEAT_PERM_MANAGEMENT */

int
acl_tmpl_init(void)
{
    if (acl_common_tmpl_init() != 0) return -1;
    return 0;
}

#endif /* !PP_FEAT_PERM_MANAGEMENT */

