#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {};

// dmesg buffer is 16 kb; add some extra space for <br> instead of \n etc.
#define DEBUG_BUFFER_SIZE       (16384 + 2048)

static int get_kernel_debug_asp(int eid, webs_t wp, int argc, char **argv);
static void output_debug_file(int eid, const char *file);

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

static char debug_buffer[DEBUG_BUFFER_SIZE];

int
debug_kernel_tmpl_init(void)
{
    form_handler_t * fh;
    
    /* register ASPs */
    websAspDefine("getKernelDebug", get_kernel_debug_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_DEBUG_KERNEL, ACL_OBJ_SUPER);
    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);   
    
    return 0;
}

static int pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED) {
    if (form_button_clicked(wp, "action_clear")) {
        pp_system("dmesg -c >/dev/null");
    }
    return 0;
}

static int
get_kernel_debug_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    /* generate memory/fs/process debug output */
    if (pp_system("dmesg > /tmp/dmesg.out") != -1) {
	output_debug_file(eid, "/tmp/dmesg.out");
    }

    return 0;
}

static void
output_debug_file(int eid, const char *file)
{
    FILE* dbgfile;
    char linebuf[128];
    char *bufptr;
    
    dbgfile = fopen(file, "r");
    if (dbgfile) {
	bufptr = debug_buffer;
	while( fgets( linebuf, 128, dbgfile ) != NULL &&
	       (bufptr - debug_buffer) < DEBUG_BUFFER_SIZE) {
	    strcpy(bufptr, linebuf);
	    bufptr += strlen(linebuf)-1;
	    strncpy(bufptr, "<BR>", 4);
	    bufptr += 4;
	}
	fclose(dbgfile);
	*bufptr = '\0';
	ejSetResult(eid, debug_buffer);
    }    
}
