#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define IPMI_ALERT_DEST_TYPE_PET        0x0
#define IPMI_ALERT_DEST_TYPE_EMAIL      0x6 /* Peppercon OEM */

#define TABLE(t)    "<table>" t "</table>"
#define TR(t)       "<tr>" t "</tr>"
#define TD(t)       "<td class=\"normal\">" t "</td>"
#define TD_B(t)     "<td class=\"bold\">" t "</td>"
#define TD_L(t)     "<td class=\"elem_l\">" t "</td>"
#define TD_R(t)     "<td class=\"elem_r\">" t "</td>"
#define TD_LB(t)     "<td class=\"elem_l bold\">" t "</td>"
#define TD_RB(t)     "<td class=\"elem_r bold\">" t "</td>"

FV_SPEC = {
};

static pp_ipmi_lanp_dest_list_entry_t modify_entry;

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int ipmi_alert_build_recipient_table_asp(int eid, webs_t wp, int argc, char **argv);

int ipmi_alerts_tmpl_init(void)
{
    form_handler_t * fh;

    /* init modify entry (at table end) */
    memset(&modify_entry, 0, sizeof(modify_entry));

    /* register ASPs */
    websAspDefine("ipmiGetAlertRecipientTable", ipmi_alert_build_recipient_table_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_ALERTS, ACL_OBJ_IPMI_STATUS);
    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

/* the formular handler (parses the buttons) */
static int pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    const char *s;
    const char *errstr = NULL;

    memset(&modify_entry, 0, sizeof(modify_entry));

    s = websGetVar(wp, "alert_retries", "0");
    modify_entry.retries = pp_strtoul_10(s, 0, NULL);
    if (modify_entry.retries > 7) errstr = "Retries";

    s = websGetVar(wp, "alert_timeout", "0");
    modify_entry.timeout = pp_strtoul_10(s, 0, NULL);

    s = websGetVar(wp, "alert_email", "");
    strncpy(modify_entry.email, s, sizeof(modify_entry.email));

    s = websGetVar(wp, "alert_ip", "");
    if (inet_pton(AF_INET, s, modify_entry.ip_addr) < 0) errstr = "IP";

    s = websGetVar(wp, "alert_mac", "");
    {
        int i, mac[6];
        if (sscanf(s, "%02x:%02x:%02x:%02x:%02x:%02x",
                   mac, mac + 1, mac + 2, mac + 3, mac + 4, mac + 5) != 6) errstr = "MAC";
        for (i = 0; i < 6; i++) modify_entry.mac_addr[i] = mac[i];
    }

    s = websGetVar(wp, "alert_gw", "");
    if (strcmp(s, "backup") == 0) modify_entry.backup_gateway = 1;
    else modify_entry.backup_gateway = 0;

    s = websGetVar(wp, "alert_type", "");
    if (strcmp(s, "EMail Notification") == 0) modify_entry.type = IPMI_ALERT_DEST_TYPE_EMAIL;
    else modify_entry.type = IPMI_ALERT_DEST_TYPE_PET;

    s = websGetVar(wp, "alert_id", "0");
    modify_entry.id = pp_strtoul_10(s, 0, NULL);
    if (modify_entry.id < 1 || modify_entry.id > 15) errstr = "ID";

    return 0;
}

static void build_table_field(pp_strstream_t *tab, const char* text)
{
    pp_strappend(tab, "<td>");
    pp_strappend(tab, text);
    pp_strappend(tab, "</td>");
}

static void build_table_row(pp_strstream_t *tab, int idx, const char* name, const char* method, const char* status)
{
    char s[64], *p;
    pp_strappend(tab, "<tr>");

    snprintf(s, sizeof(s), "%d.", idx);
    build_table_field(tab, s);

    p = escape_html(name);
    snprintf(s, sizeof(s), "<a href=\"ipmi_alert_recipient.asp?idx=%d\">%s</a>", idx, p);
    build_table_field(tab, s);
    free(p);

    p = escape_html(method);
    build_table_field(tab, p);
    free(p);

    p = escape_html(status);
    build_table_field(tab, p);
    free(p);

    pp_strappend(tab, "</tr>");
}

static int ipmi_alert_build_recipient_table_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    pp_ipmi_return_t ipmi_ret;
    pp_strstream_t tab = PP_STRSTREAM_INITIALIZER;
    int i;

    pp_strstream_init(&tab);
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));

    for (i = 1; i <= 15; i++) {
        if (i == 1) build_table_row(&tab, i, "Test", "x", "y");
        else build_table_row(&tab, i, "-empty-", "x", "y");
    }

    ejSetResult(eid, tab.buf ? tab.buf : "");

    pp_strstream_free(&tab);

    pp_ipmi_cleanup_ret(&ipmi_ret);
    return 0;
}
