#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

FV_SPEC = {
    /* we have no form vars (yet) */
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int ipmi_powerctrl_get_state_asp(int eid, webs_t wp, int argc, char **argv);
static int ipmi_powerctrl_get_counter_asp(int eid, webs_t wp, int argc, char **argv);
static int ipmi_powerctrl_get_cause_asp(int eid, webs_t wp, int argc, char **argv);

int ipmi_chassis_info_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiGetPowerState", ipmi_powerctrl_get_state_asp);
    websAspDefine("ipmiGetPowerCounter", ipmi_powerctrl_get_counter_asp);
    websAspDefine("ipmiGetRestartCause", ipmi_powerctrl_get_cause_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_CHASSIS_INFO, ACL_OBJ_IPMI_STATUS);
    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

/* the formular handler (parses the buttons) */
static int pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (form_button_clicked(wp, "action_refresh")) {
            /* dont show "Operation Completed" */
            set_response(wp, ERIC_RESPONSE_OK, "");
    }

    return 0;
}

/* ASP calls */
static int ipmi_powerctrl_get_state_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED) {
    pp_ipmi_return_t ipmi_ret;    
    int err;

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));

    if (PP_ERR == pp_ipmi_send_command(PP_IPMI_CMD_BMC, PP_IPMI_BMC_SUBCMD_GET_ACPI_STATE, NULL, &ipmi_ret, &err, wp->user))
        set_response(wp, ERIC_RESPONSE_ERROR, pp_ipmi_get_error_string(err));    

    switch (ipmi_ret.data.bmc_acpi_state.sys_state) {
      case PP_IPMI_ACPI_SYS_STATE_S4:	
      case PP_IPMI_ACPI_SYS_STATE_S5:
      case PP_IPMI_ACPI_SYS_STATE_S45:
      case PP_IPMI_ACPI_SYS_STATE_MECHOFF:	
      case PP_IPMI_ACPI_SYS_STATE_S5OVR:	
      case PP_IPMI_ACPI_SYS_STATE_LEGOFF:
	  ejSetResult(eid, _("Off"));
	  break;
      case PP_IPMI_ACPI_SYS_STATE_UNKNOWN:
	  ejSetResult(eid, _("Unknown"));
	  break;
      default:
	  ejSetResult(eid, _("On"));
    }

    pp_ipmi_cleanup_ret(&ipmi_ret);
    return 0;
}

static int ipmi_powerctrl_get_counter_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED) {
    pp_ipmi_return_t ipmi_ret;
    int err;

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));

    if (PP_ERR == pp_ipmi_send_command(PP_IPMI_CMD_CHASSIS, PP_IPMI_CHASSIS_SUBCMD_POH, NULL, &ipmi_ret, &err, wp->user))
        set_response(wp, ERIC_RESPONSE_ERROR, pp_ipmi_get_error_string(err));

    pp_log("Power Up Counter: %s\n", ipmi_ret.data.chassis_poh.buf);
    ejSetResult(eid, ipmi_ret.data.chassis_poh.buf);

    pp_ipmi_cleanup_ret(&ipmi_ret);
    return 0;
}

static int ipmi_powerctrl_get_cause_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED) {
    pp_ipmi_return_t ipmi_ret;
    int err;

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));

    if (PP_ERR == pp_ipmi_send_command(PP_IPMI_CMD_CHASSIS, PP_IPMI_CHASSIS_SUBCMD_RESTART_CAUSE, NULL, &ipmi_ret, &err, wp->user))
        set_response(wp, ERIC_RESPONSE_ERROR, pp_ipmi_get_error_string(err));

    pp_log("Restart Cause: %s\n", ipmi_ret.data.chassis_restart_cause.buf);
    ejSetResult(eid, ipmi_ret.data.chassis_restart_cause.buf);

    pp_ipmi_cleanup_ret(&ipmi_ret);
    return 0;
}
