#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "templates.h"

#ifdef PP_FEAT_IPMI_CLIENT_EVENTS

static const char * invalid_range_msg = N_("The '%s' value is incorrect.");
static const char * sel_not_supported_msg = N_("The event log is not accessible on the connected host!");

FV_SPEC = {
    {
	id:		FV_ID_IPMI_EVENTS_RANGE,
	cfgkey:		"ipmi.events.range",
    },
    {
	id:		FV_ID_IPMI_EVENTS_RANGE_FROM,
	cfgkey:		"ipmi.events.range_from",
    },
    {
	id:		FV_ID_IPMI_EVENTS_RANGE_TO,
	cfgkey:		"ipmi.events.range_to",
    },
};

static int post_save_hook(webs_t wp, form_handler_t * fh);

int
ipmi_events_tmpl_init(void)
{
    form_handler_t * fh;
    
    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_EVENTS, ACL_OBJ_IPMI_EVENTS);

    fh->post_save_hook = post_save_hook;
    
    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_save_hook(webs_t wp UNUSED, form_handler_t * fh)
{   
    char opt_name[MAX_OPT_KEY_LEN + 1];
    char cnt_opt_val[11];
    char time_buf[24];
    struct tm tm;
    int event_count;
    int i, j, error = 0, ret;
    const char * s;
    pp_ipmi_return_t ipmi_ret;
    pp_ipmi_parameter_t ipmi_param;

    if ( form_button_clicked(wp, "action_clear_event_log") ) {
	if (ipmi_sel_clear_log(wp)) {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Error while deleting the System Event Log!"));
	}
    }
    
    memset(&ipmi_param, 0, sizeof(ipmi_param));

    if ( form_button_clicked(wp, "action_update") ) {
	if (!strcmp(fh->fv[FV_ID_IPMI_EVENTS_RANGE].val.s, "1d")) {
	    ipmi_param.data.sel_list.range = PP_IPMI_SEL_LIST_RANGE_LASTDAY;
	} else if (!strcmp(fh->fv[FV_ID_IPMI_EVENTS_RANGE].val.s, "3d")) {
	    ipmi_param.data.sel_list.range = PP_IPMI_SEL_LIST_RANGE_LAST3DAYS;
	} else if (!strcmp(fh->fv[FV_ID_IPMI_EVENTS_RANGE].val.s, "7d")) {
	    ipmi_param.data.sel_list.range = PP_IPMI_SEL_LIST_RANGE_LASTWEEK;
	} else if (!strcmp(fh->fv[FV_ID_IPMI_EVENTS_RANGE].val.s, "30d")) {
	    ipmi_param.data.sel_list.range = PP_IPMI_SEL_LIST_RANGE_LASTMONTH;
	} else if (!strcmp(fh->fv[FV_ID_IPMI_EVENTS_RANGE].val.s, "user")) {
	    ipmi_param.data.sel_list.range = PP_IPMI_SEL_LIST_RANGE_FROMTO;
	    s = strptime(fh->fv[FV_ID_IPMI_EVENTS_RANGE_FROM].val.s, "%Y-%m-%d", &tm);
	    if (s && *s == '\0') {
		tm.tm_sec = tm.tm_min = tm.tm_hour = 0; /* this is necessary */
		ipmi_param.data.sel_list.from = mktime(&tm);
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, invalid_range_msg,
			     fh->fv[FV_ID_IPMI_EVENTS_RANGE_FROM].label);
		return 0;
	    }
	    s = strptime(fh->fv[FV_ID_IPMI_EVENTS_RANGE_TO].val.s, "%Y-%m-%d", &tm);
	    if (s && *s == '\0') {
		tm.tm_sec = 59; tm.tm_min = 59; tm.tm_hour = 23;
		ipmi_param.data.sel_list.to = mktime(&tm);
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, invalid_range_msg,
			     fh->fv[FV_ID_IPMI_EVENTS_RANGE_TO].label);
		return 0;;
	    }
	} else if (!strcmp(fh->fv[FV_ID_IPMI_EVENTS_RANGE].val.s, "all")) {
	    ipmi_param.data.sel_list.range = PP_IPMI_SEL_LIST_RANGE_ALL;
	} else {
	    ipmi_param.data.sel_list.range = PP_IPMI_SEL_LIST_RANGE_LASTDAY;
	}
	
	websSetVar(wp, "_range", fh->fv[FV_ID_IPMI_EVENTS_RANGE].val.s);

    	memset(&ipmi_ret, 0, sizeof(ipmi_ret));
	if (pp_ipmi_send_command(PP_IPMI_CMD_SEL, PP_IPMI_SEL_SUBCMD_GET_TIME, NULL, &ipmi_ret, NULL, wp->user) == 0) {
	    gmtime_r(&ipmi_ret.data.sel_get_time.timestamp, &tm);
	    strftime(time_buf, sizeof(time_buf), "%Y-%m-%d %H:%M:%S", &tm);
	    websSetVar(wp, "ipmi_system_time", time_buf);
	} else {
	    websSetVar(wp, "ipmi_system_time", "unknown");
	}
	pp_ipmi_cleanup_ret(&ipmi_ret);
	
    	memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    	ret = pp_ipmi_send_command(PP_IPMI_CMD_SEL, PP_IPMI_SEL_SUBCMD_LIST, &ipmi_param, &ipmi_ret, NULL, wp->user);

	if (ret == 0) {
	    event_count = vector_size(ipmi_ret.data.sel_list);
	    pp_log("Event Count: %d\n", event_count);
	    
	    for (i = event_count - 1, j = 0; i >= 0; i--) {
		pp_ipmi_sel_list_entry_t *entry = vector_get(ipmi_ret.data.sel_list, i);
		
		if (!entry) {
		    continue;
		}
		
                form_var_vec_name("event_time", j, opt_name, sizeof(opt_name));
		gmtime_r(&entry->timestamp.timestamp, &tm);
		strftime(time_buf, sizeof(time_buf), "%Y-%m-%d %H:%M:%S", &tm);
		websSetVar(wp, opt_name, time_buf);
		
                form_var_vec_name("event_sensor", j, 
                                  opt_name, sizeof(opt_name));
		s = entry->sensor_name.buf ? entry->sensor_name.buf : "";
		websSetVar(wp, opt_name, s);
		
                form_var_vec_name("event_descr", j, opt_name, sizeof(opt_name));
		s = entry->description.buf ? entry->description.buf : "";
		websSetVar(wp, opt_name, s);
		
		j++;
	    }
	} else if (error == 0xC1) {	   
	    set_response(wp, ERIC_RESPONSE_ERROR, sel_not_supported_msg);
	    pp_ipmi_cleanup_ret(&ipmi_ret);
	    return 0;
	} else {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Error while reading System Event Log!"));
	    event_count = 0;
	}
	
	pp_ipmi_cleanup_ret(&ipmi_ret);

	snprintf(cnt_opt_val, sizeof(cnt_opt_val), "%u", event_count);
	websSetVar(wp, "event_time_cnt", cnt_opt_val);
	websSetVar(wp, "_need_update", "no");
    } else {
	websSetVar(wp, "_need_update", "yes");
    }

    return 0;
}

#else /* !PP_FEAT_IPMI_CLIENT_EVENTS */

int ipmi_events_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_IPMI_CLIENT_EVENTS */
