#include <liberic_config.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

FV_SPEC = {
    /* we have no form vars (yet) */
};

/* ASP calls */
static int ipmi_fru_query_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char **argv UNUSED)
{
    pp_ipmi_return_t ipmi_ret;
    int err;

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));

    if (PP_ERR == pp_ipmi_send_command(PP_IPMI_CMD_BMC,
        PP_IPMI_BMC_SUBCMD_INFO, NULL, &ipmi_ret, &err, wp->user)) {
        set_response(wp, ERIC_RESPONSE_ERROR, pp_ipmi_get_error_string(err));
        return 0;
    }

    websSetVar(wp, "bmc_fw_revision", pp_strstream_buf(&ipmi_ret.data.bmc_info.firmware_revision));
    websSetVar(wp, "bmc_ipmi_version", pp_strstream_buf(&ipmi_ret.data.bmc_info.ipmi_version));

    pp_ipmi_cleanup_ret(&ipmi_ret);

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));

    if (PP_ERR == pp_ipmi_send_command(PP_IPMI_CMD_FRU,
        PP_IPMI_FRU_SUBCMD_BOARD, NULL, &ipmi_ret, &err, wp->user)) {
        set_response(wp, ERIC_RESPONSE_ERROR, pp_ipmi_get_error_string(err));
        return 0;
    }

    websSetVar(wp, "chassis_type", pp_strstream_buf(&ipmi_ret.data.fru_info.chassis.type));
    websSetVar(wp, "chassis_model", pp_strstream_buf(&ipmi_ret.data.fru_info.chassis.model));
    websSetVar(wp, "chassis_serial", pp_strstream_buf(&ipmi_ret.data.fru_info.chassis.serial));

    websSetVar(wp, "board_mfg_date", pp_strstream_buf(&ipmi_ret.data.fru_info.board.mfg_time.string_date));
    websSetVar(wp, "board_manufacturer", pp_strstream_buf(&ipmi_ret.data.fru_info.board.manufacturer));
    websSetVar(wp, "board_name", pp_strstream_buf(&ipmi_ret.data.fru_info.board.name));
    websSetVar(wp, "board_serial", pp_strstream_buf(&ipmi_ret.data.fru_info.board.serial));
    websSetVar(wp, "board_model", pp_strstream_buf(&ipmi_ret.data.fru_info.board.model));
    websSetVar(wp, "board_fru_id", pp_strstream_buf(&ipmi_ret.data.fru_info.board.fru_id));

    websSetVar(wp, "product_manufacturer", pp_strstream_buf(&ipmi_ret.data.fru_info.product.manufacturer));
    websSetVar(wp, "product_name", pp_strstream_buf(&ipmi_ret.data.fru_info.product.name));
    websSetVar(wp, "product_model", pp_strstream_buf(&ipmi_ret.data.fru_info.product.model));
    websSetVar(wp, "product_ver", pp_strstream_buf(&ipmi_ret.data.fru_info.product.version));
    websSetVar(wp, "product_serial", pp_strstream_buf(&ipmi_ret.data.fru_info.product.serial));
    websSetVar(wp, "product_asset", pp_strstream_buf(&ipmi_ret.data.fru_info.product.asset));
    websSetVar(wp, "product_fru_id", pp_strstream_buf(&ipmi_ret.data.fru_info.product.fru_id));

    pp_ipmi_cleanup_ret(&ipmi_ret);

    return 0;
}

static int
get_system_guid_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    pp_ipmi_return_t ipmi_ret;
    int ret, err;
    char guid[37];

    ret = pp_ipmi_send_command(PP_IPMI_CMD_BMC, PP_IPMI_BMC_SUBCMD_GET_SYSTEM_GUID,
	    NULL, &ipmi_ret, &err, NULL);
    if (ret) {
	return 0;
    }
    unsigned char *d = ipmi_ret.data.bmc_system_guid.guid;
    snprintf(guid, sizeof(guid), "%02x%02x%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x",
	    d[0], d[1], d[2], d[3], d[4], d[5], d[6], d[7],
	    d[8], d[9], d[10], d[11], d[12], d[13], d[14], d[15]);

    pp_ipmi_cleanup_ret(&ipmi_ret);

    ejSetResult(eid,guid);

    return 0;
}

/* init */
int ipmi_fru_info_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiFRUQuery", ipmi_fru_query_asp);
    websAspDefine("getSystemGuid", get_system_guid_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_FRU_INFO, ACL_OBJ_IPMI_STATUS);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}
