#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

/* internal prototypes */

FV_SPEC = {
{
    id:             FV_ID_LAN_DEST_OPTIONS_COMMUNITY,
    cfgkey:         "bmc.lan.alert.community",
},
{
    id:             FV_ID_LAN_DEST_OPTIONS_SMTPSERVER,
    cfgkey:         "bmc.lan.alert.smtp_server",
},
{
    id:             FV_ID_LAN_DEST_OPTIONS_EMAIL_ADDR,
    cfgkey:         "bmc.lan.alert.mail_alert_from",
},
};

int ipmi_lan_dest_options_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_LAN_DEST_OPTIONS, ACL_OBJ_IPMI_STATUS);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

