#include <pp/kvm.h>
#include "eric_forms.h"
#include "webs.h"
#include "wsIntrn.h"

static int kvm_get_curr_unit_and_port_asp(int eid, webs_t wp, int argc, char **argv);
static int kvm_get_channel_count_asp(int eid, webs_t wp, int argc, char **argv);
static int kvm_get_unit_port_count_asp(int eid, webs_t wp, int argc, char **argv);
static int kvm_get_max_unit_port_count_asp(int eid, webs_t wp, int argc, char **argv);
static int kvm_get_max_unit_count_asp(int eid, webs_t wp, int argc, char **argv);
static int kvm_get_portname_from_index_asp(int eid, webs_t wp, int argc, char **argv);
static int kvm_is_port_switch_allowed_asp(int eid, webs_t wp, int argc, char **argv);

int
kvm_common_tmpl_init(void)
{
    static int initialized = 0;

    if (!initialized) {
	/* register ASPs */
	websAspDefine("kvmGetCurrUnitAndPort", kvm_get_curr_unit_and_port_asp);
	websAspDefine("kvmGetChannelCount", kvm_get_channel_count_asp);
	websAspDefine("kvmGetUnitPortCount", kvm_get_unit_port_count_asp);
	websAspDefine("kvmGetMaxUnitPortCount", kvm_get_max_unit_port_count_asp);
	websAspDefine("kvmGetMaxUnitCount", kvm_get_max_unit_count_asp);
	websAspDefine("kvmGetPortnameFromIndex", kvm_get_portname_from_index_asp);
	websAspDefine("kvmIsPortSwitchAllowed", kvm_is_port_switch_allowed_asp);

	initialized = 1;
    }

    return 0;
}

static int
kvm_get_curr_unit_and_port_asp(int eid UNUSED, webs_t wp, int argc, char **argv)
{
    char number_str[12];
    u_char channel = 0;
    u_char unit = 0;
    u_short port = 0;

    if (argc == 3) {
	channel = pp_strtoul_10(argv[0], 0, NULL);
	if (pp_kvm_get_unit_port_for_video_link(channel, &unit, &port) != 0) {
	    /* FIXME */
	    unit = 0;
	    port = 0;
	}
	snprintf(number_str, sizeof(number_str), "%hhu", unit);
	websSetVar(wp, argv[1], number_str);
	snprintf(number_str, sizeof(number_str), "%hu", port);
	websSetVar(wp, argv[2], number_str);
    }

    return 0;
}

static int
kvm_get_channel_count_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    char number_str[12];
    snprintf(number_str, sizeof(number_str), "%hhu", pp_kvm_get_channel_count());
    ejSetResult(eid, number_str);
    return 0;
}

static int
kvm_get_unit_port_count_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    char number_str[12];
    u_char unit = argc == 1 ? (u_char)pp_strtoul_10(argv[0], 0, NULL) : 0;
    snprintf(number_str, sizeof(number_str), "%hu", pp_kvm_get_unit_port_count(unit));
    ejSetResult(eid, number_str);
    return 0;
}

static int
kvm_get_max_unit_port_count_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    char number_str[12];
    snprintf(number_str, sizeof(number_str), "%hu", PP_KVM_MAX_UNIT_PORT_COUNT);
    ejSetResult(eid, number_str);
    return 0;
}

static int
kvm_get_max_unit_count_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    char number_str[12];
    snprintf(number_str, sizeof(number_str), "%hhu", PP_KVM_MAX_UNIT_PORT_COUNT);
    ejSetResult(eid, number_str);
    return 0;
}

void
kvm_get_portname_from_index(int id, char *name, int name_max)
{
#if defined(PRODUCT_XX01IP_ANY) && !defined(PRODUCT_XX01IPTT_ANY) && !defined(OEM_RARITAN)
    if (id < 8) {
	snprintf(name, name_max, "%u", id + 1);
    } else {
	snprintf(name, name_max, "%c", 65 + (id - 8));
    }
#else
    snprintf(name, name_max, "%u", id + 1);
#endif
}

static int
kvm_get_portname_from_index_asp(int eid, webs_t wp UNUSED, int argc, char **argv)
{
    char name[3];
    u_int id;

    if (argc == 1) {
	id = pp_strtoul_10(argv[0], 0, NULL);
	kvm_get_portname_from_index(id, name, sizeof(name));
	ejSetResult(eid, name);
    } else {
	ejSetResult(eid, "");
    }
    return 0;
}

static int
kvm_is_port_switch_allowed_asp(int eid, webs_t wp, int argc, char **argv)
{
    const char *user;
    u_int port;
    int allowed;

    if (argc == 1) {
	user = wp->user;
	port = pp_strtoul_10(argv[0], 0, NULL);
	allowed = pp_kvm_switch_allowed(user, 0 /* unit */, port);
	ejSetResult(eid, allowed ? "yes" : "no");
    } else {
	ejSetResult(eid, "");
    }
    return 0;
}
