#include <pp/base.h>
#include <pp/powerswitch.h>
#include <liberic_misc.h>
#include <pp/um.h>
#include <pp/kvm.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"
#include <liberic_config.h>
#include <pp/cfg.h>

#if 0
/* replaced by tmpl_kvm_powerctrl - do not delete yet! - (rwa) */

FV_SPEC = {
    {
	id:		FV_ID_KVM_PC_PORT_1,
	cfgkey:		"pc.port_0"
    },
    {
	id:		FV_ID_KVM_PC_DEVICE_1,
	cfgkey:		"pc.device_0"
    },
    {
    	id:		FV_ID_KVM_PC_PORT_2,
	cfgkey:		"pc.port_1"
    },
    {
	id:		FV_ID_KVM_PC_DEVICE_2,
	cfgkey:		"pc.device_1"
    }
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int init_kvm_pc_settings_asp(int eid, webs_t wp, int argc, char ** argv);

int
kvm_pc_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("initKvmPcSettings", init_kvm_pc_settings_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_KVM_PC, ACL_OBJ_KVM);
                         
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    form_var_t * form_vars = NULL;
    form_var_t * fv_device = NULL,
	       * fv_port   = NULL;
    
    int i, item_id, serial_id, error;
    int kvm_port_id = 0;
    int entry_cnt = 0;
    int list_cnt = 0;
    char val[MAX_OPT_KEY_LEN + 1],
	 kvm_port_str[MAX_OPT_KEY_LEN+1],
         var_name[MAX_OPT_KEY_LEN + 1],
         serial_port_str[MAX_OPT_KEY_LEN + 1],
	 switch_id_str[MAX_OPT_KEY_LEN + 1],
	 dev_str[MAX_OPT_KEY_LEN + 1],
	 port_str[MAX_OPT_KEY_LEN + 1];
    char *config_var  = NULL,
         *pwr_port    = NULL,
	 *switch_id_1 = NULL,
	 *switch_id_2 = NULL,
	 *switch_id_s = NULL,
	 *pswitch_vendor = NULL,		
	 *cur_sw_id      = NULL,
         *sel_item    = NULL,
         *_kvm_power_entries = websGetVar(wp, "_kvm_power_entries", ""),
         *_fv_serial_val = websGetVar(wp, "_kvm_pc_serial_port", "");



    /* Get selected port values for serial port 1 */
    if ( !strcmp(_fv_serial_val, "0") ) {
	fv_device = &form_vars[FV_ID_KVM_PC_DEVICE_1];
	fv_port = &form_vars[FV_ID_KVM_PC_PORT_1];
	switch_id_s = switch_id_1;
    /* Get selected port values for serial port 2 */
    } else if ( !strcmp(_fv_serial_val, "1") ) {
	fv_device = &form_vars[FV_ID_KVM_PC_DEVICE_2];
	fv_port = &form_vars[FV_ID_KVM_PC_PORT_2];
	switch_id_s = switch_id_2;	
    }
       
    /* button handling */
    if (form_button_clicked(wp, "action_append")) {
	/* if device or port is not set, save nothing */
	if ( !fv_device || !fv_port ||
	     (!strcmp(fv_device->val.s, "") &&
	      !strcmp(fv_port->val.s, "")) ) goto finish;
	
	snprintf(var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, entry_cnt);
	snprintf(val, sizeof(val), "%s:%s:%s:%s",
		 _fv_serial_val,		
		 fv_device->val.s,		 
		 fv_port->val.s,
		 switch_id_s);
        error = pp_cfg_set(val, var_name);
	snprintf(var_name, sizeof(var_name), "kvm_powerport_%d_cnt", kvm_port_id);
	snprintf(val, sizeof(var_name), "%d", ++entry_cnt);
        error = pp_cfg_set(val, var_name);
	
    } else if (form_button_clicked(wp, "action_delete")) {	
	if ( strcmp(_kvm_power_entries, "") ) {
	    sel_item =  strdup(_kvm_power_entries);

	    item_id = strtol(sel_item, NULL, 10);
	    for ( i = item_id; i < entry_cnt - 1; i++ ) {
		snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, i + 1);
                error = pp_cfg_get(&config_var, var_name);
		
		snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, i);
                error = pp_cfg_set(config_var, var_name);
		free ( config_var );		
	    }
	    snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, entry_cnt - 1);
            error = pp_cfg_set("", var_name);

	    snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_cnt", kvm_port_id);
	    snprintf( val, sizeof(var_name), "%d", --entry_cnt);
            error = pp_cfg_set(val, var_name);
	}
	
    } else if (form_button_clicked(wp, "action_insert")) {
	/* if device or port is not set, save nothing */
	if ( !fv_device || !fv_port ||
	    (!strcmp(fv_device->val.s, "") &&
	     !strcmp(fv_port->val.s, "")) ) goto finish;
	
	if ( strcmp(_kvm_power_entries, "") ) {
	    sel_item =  strdup(_kvm_power_entries);
	    item_id = strtol(sel_item, NULL, 10);
	} else {
	    item_id = 0;
	}

	for ( i = entry_cnt - 1; i >= item_id; i-- ) {
	    snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, i);
            error = pp_cfg_get(&config_var, var_name);
	    
	    snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, i + 1);
            error = pp_cfg_set(val, config_var);
	    free ( config_var );		
	}
	snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, item_id);
	snprintf(val, sizeof(val), "%s:%s:%s:%s",
		 _fv_serial_val,		
		 fv_device->val.s,		 
		 fv_port->val.s,
		 switch_id_s);
        error = pp_cfg_set(val, var_name);
	snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_cnt", kvm_port_id);
	snprintf( val, sizeof(var_name), "%d", ++entry_cnt);
        error = pp_cfg_set(val, var_name);
	
    } else if (form_button_clicked(wp, "action_up")) {
	if ( strcmp(_kvm_power_entries, "") ) {	    
	    sel_item =  strdup(_kvm_power_entries);
	    item_id = strtol(sel_item, NULL, 10);
	    if ( item_id > 0 ) {
		char *prev_val = NULL;
		char prev_var[MAX_OPT_KEY_LEN+1];
		snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, item_id);		
                error = pp_cfg_get(&config_var, var_name);
		
		snprintf( prev_var, sizeof(prev_var), "kvm_powerport_%d_%d", kvm_port_id, item_id - 1);
                error = pp_cfg_get(&prev_val, prev_var);
		
                error = pp_cfg_set(prev_val, var_name);
                error = pp_cfg_set(config_var, prev_var);
		
		snprintf( var_name, sizeof(var_name), "_sel_listbox_item");
		snprintf( val, sizeof(var_name), "%d", item_id - 1);
		websSetVar(wp, var_name, val);
		
		free ( config_var );
		free ( prev_val );
	    }	   
	}	
    } else if (form_button_clicked(wp, "action_down")) {	
	if ( strcmp(_kvm_power_entries, "") ) {	    
	    sel_item =  strdup(_kvm_power_entries);
	    item_id = strtol(sel_item, NULL, 10);
	    if ( item_id < entry_cnt - 1 ) {
		char *next_val = NULL;
		char next_var[MAX_OPT_KEY_LEN+1];
		snprintf( var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, item_id);		
                error = pp_cfg_get(&config_var, var_name);
		
		snprintf( next_var, sizeof(next_var), "kvm_powerport_%d_%d", kvm_port_id, item_id + 1);
                error = pp_cfg_get(&next_val, next_var);
		
                error = pp_cfg_set(next_val, var_name);
                error = pp_cfg_set(config_var, next_var);

		item_id++;
		free ( config_var );
		free ( next_val );
	    }	    
	    snprintf( var_name, sizeof(var_name), "_sel_listbox_item");
	    snprintf( val, sizeof(var_name), "%d", item_id);
	    websSetVar(wp, var_name, val);	    
	}	
    } else {
	goto finish;
    }    
    
    pp_cfg_save(DO_FLUSH);

    /* Set comboboxes to previously selected values. FIX ME: find a better place for this
     * because this is not done if someone goto finish */
    websSetVar(wp, "_serial_port", _fv_serial_val);	
    websSetVar(wp, "_dev_id_1", (&form_vars[FV_ID_KVM_PC_DEVICE_1])->val.s);
    websSetVar(wp, "_port_id_1", (&form_vars[FV_ID_KVM_PC_PORT_1])->val.s);
    
    websSetVar(wp, "_dev_id_2", (&form_vars[FV_ID_KVM_PC_DEVICE_2])->val.s);
    websSetVar(wp, "_port_id_2", (&form_vars[FV_ID_KVM_PC_PORT_2])->val.s);
    
 finish:
    /* write all listbox entrys to asp */
    for ( i = 0; i < entry_cnt; i++ ) {
	int port_id;
	/* get kvm power port config string for kvm port 'kvm_port_id' and id 'i' */
	snprintf(var_name, sizeof(var_name), "kvm_powerport_%d_%d", kvm_port_id, i);
        error = pp_cfg_get(&pwr_port, var_name);
	if ( !pwr_port || (strlen(pwr_port) > MAX_OPT_KEY_LEN) ) continue;	
	/* parse config string */
	if (sscanf(pwr_port, "%[^:]:%[^:]:%[^:]:%s", serial_port_str, dev_str, port_str, switch_id_str) != 4) {
	    continue;
	}
	serial_id = strtol(serial_port_str, NULL, 10) + 1;
	port_id = pp_power_map_serial_port_to_id(serial_id);

	if (pp_power_login(port_id) == 0) {
	    pswitch_vendor = pp_power_get_long_name(switch_id_str);
	    /* get the switch id of the power switch that is currently set and look
	     * if it matches the switch id of the kvm power port... */
	    cur_sw_id = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_ID, port_id);

	    if ( !cur_sw_id || strcmp(cur_sw_id, switch_id_str) ) {
		/*
		 * ...if not, simply write: 'power_switch' is unavailable!
		 * as designed, we only get port and device names from the power
		 * switch that is currently set in serial settings, so the
		 * 'unavailable' message circumvent this constraint
		 */
		snprintf(kvm_port_str, sizeof(kvm_port_str),
			 _("Serial %d - %s is unavailable!"), serial_id, pswitch_vendor);	
	    } else {
		/* here we get port and device names and write all the power port
		 * data to a single string */
		int dev = 0;
		int port = 0;
		char *lst_devname  = NULL;
		char *lst_portname = NULL;
		
		if (dev_str) { dev = strtol(dev_str, NULL, 10); }
		if (port_str) { port = strtol(port_str, NULL, 10); }
		
		lst_devname = pp_power_get_name(0, dev, PWR_OBJ_DEVICE, port_id);
		lst_portname = pp_power_get_name(port, 0, PWR_OBJ_PORT, port_id);

		if (lst_devname) {
		    snprintf(kvm_port_str, sizeof(kvm_port_str),
			     _("Serial %d - %s - %s - %s"), serial_id, pswitch_vendor, lst_devname, lst_portname);
		} else {
		    snprintf(kvm_port_str, sizeof(kvm_port_str),
			     _("Serial %d - %s - %s"), serial_id, pswitch_vendor, lst_portname);
		}
		free(lst_devname);
		free(lst_portname);
	    }
	    free(cur_sw_id);
	    free(pswitch_vendor);
	    pp_power_login(port_id);
	}
	/* write the power port string to the web page, later shown as a line	   
	 * in the list box */
	list_cnt++;
	snprintf(var_name, sizeof(var_name), "_kvm_powerport_%d", i);	    
	websSetVar(wp, var_name, kvm_port_str);		   
	free(pwr_port);
    }
    /* set list box entry count to asp */
    snprintf(var_name, sizeof(var_name), "%d", list_cnt);
    websSetVar(wp, "_kvm_powerport_cnt", var_name);
    
    return 0;
}

static int
init_kvm_pc_settings_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char ** argv UNUSED)
{
    int i, dev_cnt, port_cnt, error;
    int kvm_port_id = 0;
    int entry_cnt = 0;
    char val[MAX_OPT_KEY_LEN + 1],
         var_name[MAX_OPT_KEY_LEN + 1];
    char *config_var  = NULL,
	 *webs_var    = NULL,
	 *power_name  = NULL,
	 *switch_id_1 = NULL,
	 *switch_id_2 = NULL,
	 *switch_name = NULL;


    /* Get the id of the selected kvm port */
    webs_var = websGetVar(wp, "kvm_port", NULL);
    if ( webs_var ) {
	kvm_port_id = strtol(webs_var, NULL, 10);
	websSetVar(wp, "kvm_port", webs_var);
    } else {
	pp_log("Error: Unknow Port ID\n");
	return 0;
    }

    /* Get current power port entry count for the shown kvm port */
    snprintf(var_name, sizeof(var_name), "kvm_powerport_%d_cnt", kvm_port_id);
    error = pp_cfg_get(&config_var, var_name);
    if ( config_var ) {
	entry_cnt = strtol(config_var, NULL, 10);	
    }

    /* ------------------------------------------------------------------------
     * fill the power entry list for serial port 1
     */
    if (pp_power_open_login(PP_POWER_PORT_ID_SERIAL_1) == 0) {
	dev_cnt = pp_power_get_count(0, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_1);	
	port_cnt = pp_power_get_count(0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_1);
	switch_id_1 = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_ID, PP_POWER_PORT_ID_SERIAL_1);
	switch_name = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_NAME, PP_POWER_PORT_ID_SERIAL_1);
	if (switch_name) websSetVar(wp, "power_name_tty0", switch_name);
	
	if (dev_cnt < 0) dev_cnt = 0;
	snprintf(val, sizeof(val), "%d", dev_cnt);
	websSetVar(wp, "power_device_tty0_cnt", val);    
	
	for (i = 0; i < dev_cnt; i++) {
            form_var_vec_name("power_device_tty0", i, 
                              var_name, sizeof(var_name));
	    power_name = pp_power_get_name(0, i, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_1);
	    websSetVar(wp, var_name, power_name);
	    free(power_name);
	}
	if (port_cnt > 0) {
	    snprintf(val, sizeof(val), "%u", port_cnt);
	    websSetVar(wp, "power_port_tty0_cnt", val);
	    for (i = 0; i < port_cnt; i++) {	    
                form_var_vec_name("power_device_tty0", i, 
                                  var_name, sizeof(var_name));
		power_name = pp_power_get_name(i, 0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_1);
		websSetVar(wp, var_name, power_name);
		free(power_name);
	    }
	}
	pp_power_logout(PP_POWER_PORT_ID_SERIAL_1);
    }

    /* ------------------------------------------------------------------------
     * fill the power entry list for serial port 2
     */
    if (pp_power_open_login(PP_POWER_PORT_ID_SERIAL_2) == 0) {
	dev_cnt = pp_power_get_count(0, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_2);	
	port_cnt = pp_power_get_count(0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_2);
	switch_id_2 = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_ID, PP_POWER_PORT_ID_SERIAL_2);
	switch_name = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_NAME, PP_POWER_PORT_ID_SERIAL_2);
	if (switch_name) websSetVar(wp, "power_name_tty1", switch_name);
	
	if (dev_cnt < 0) dev_cnt = 0;
	snprintf(val, sizeof(val), "%d", dev_cnt);
	websSetVar(wp, "power_device_tty1_cnt", val);
	for (i = 0; i < dev_cnt; i++) {
            form_var_vec_name("power_device_tty1", i, 
                              var_name, sizeof(var_name));
	    power_name = pp_power_get_name(0, i, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_2);
	    websSetVar(wp, var_name, power_name);
	    free(power_name);
	}
	
	if (port_cnt > 0) {
	    snprintf(val, sizeof(val), "%u", port_cnt);
	    websSetVar(wp, "power_port_tty1_cnt", val);
	    for (i = 0; i < port_cnt; i++) {		
                form_var_vec_name("power_device_tty1", i, 
                                  var_name, sizeof(var_name));
		power_name = pp_power_get_name(i, 0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_2);
		websSetVar(wp, var_name, power_name);
		free(power_name);        	
	    }
	}
	pp_power_logout(PP_POWER_PORT_ID_SERIAL_2);
    }
    return 0;
}

#endif
