#include <pp/cfg.h>
#include <liberic_config.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "wsIntrn.h"

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int log_set_vars_asp(int eid, webs_t wp, int argc, char **argv);

FV_SPEC = {
};

int
log_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("logSetVars", log_set_vars_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_LOG, ACL_OBJ_LOG_VIEW);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (form_button_clicked(wp, "action_log_clear")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Clear' if you really want to clear the event log!"));
	websSetVar(wp, "_show_log_clear_confirm", "1");
    } else if (form_button_clicked(wp, "action_really_log_clear")) {
	char logmsg[PP_NOTIFY_MAX_MSG_LEN+1];
        snprintf(logmsg, sizeof(logmsg), _("Internal log file cleared by user '%s'."), wp->user);
        eric_notify_list_log_clear();
        eric_notify_post_event(logmsg, "device", PP_NOTIFY_EVENT_GENERIC);
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	set_response(wp, ERIC_RESPONSE_OK, _("Internal log file cleared."));
    } else if (form_button_clicked(wp, "action_switch_page")) {
	int page = 0;
	const char *page_txt = websGetVar(wp, "_page", "0");
	if (sscanf(page_txt, "%d", &page) < 1) page = 0;

        wp->sd->log_list_page = page;

	set_response(wp, ERIC_RESPONSE_OK, "");
    }
    return 0;
}

static int
log_set_vars_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char **argv UNUSED)
{
    u_int i = 0, first_id = 0, last_id = 0, id, entries_shown;
    char var_name[MAX_OPT_KEY_LEN+1];    
    char var_value[MAX_OPT_KEY_LEN+1];    
    char date_str[32];
    time_t date;
    char * event;
    char * desc;

    pp_cfg_get_uint(&entries_shown, "log.list.entries_shown");
    if (entries_shown == 0) entries_shown = 1;

    if (!form_was_submitted(wp)) {
	wp->sd->log_list_page = 0;
    }
   
    unsigned int _first = eric_notify_list_get_first_id();
    unsigned int _last = eric_notify_list_get_last_id();

    first_id = _last - entries_shown * wp->sd->log_list_page;
    if (first_id < _first) first_id = _first;

    for (i = 0, id = first_id; i < entries_shown; ++i) {
	/* theroretically it might happen that a event is added to the list between the form handler
	   and this function. this would invalidate the first shown id pointer somehow. because this
	   is not very likely and since it's planned to rewrite this code part, we simply ignore this
	   for now */	
	if (PP_FAILED(eric_notify_list_get_entry_exact(id, &date, &event, &desc))) {
	    break;
	}
	eric_notify_get_time_string(date, date_str, sizeof(date_str));
        form_var_vec_name("log_entry_date", i, var_name, sizeof(var_name));
        websSetVar(wp, var_name, date_str);
        form_var_vec_name("log_entry_event", i, var_name, sizeof(var_name));
        websSetVar(wp, var_name, event);
        form_var_vec_name("log_entry_desc", i, var_name, sizeof(var_name));
        websSetVar(wp, var_name, desc);
	free(event);
	free(desc);

	last_id = id--;
    }

    snprintf(var_value, sizeof(var_value), "%u", i);
    websSetVar(wp, "log_entry_cnt", var_value);

    int page_count = ((_last - _first) / entries_shown) + 1;
    if (page_count == 0) page_count = 1;
    char page_count_val[32];
    snprintf(page_count_val, sizeof(page_count_val), "%d", page_count);
    websSetVar(wp, "log_page_count", page_count_val);

    char page[32];
    snprintf(page, sizeof(page), "%d", wp->sd->log_list_page);
    websSetVar(wp, "log_current_page", page);

    return 0;
}
