#include <liberic_net.h>
#include <pp/cfg.h>
#include <pp/intl.h>
#include <pp/setup_proto.h>
#include <liberic_misc.h>
#include <liberic_notify.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

FV_SPEC = {
    {
	id:		FV_ID_CLUSTER_IPADDR,
	cfgkey:		"cluster.ipaddr",
    },
    {
	id:		FV_ID_CLUSTER_NETMASK,
	cfgkey:		"cluster.netmask",
    },
    {
	id:		FV_ID_CLUSTER_GATEWAY,
	cfgkey:		"cluster.gateway",
    },
#if defined (PP_FEAT_RDM_SUPPORT)
    {
	id:		FV_ID_NET_DEVICENAME,
	cfgkey:		"network.devicename"
    },
#endif /* !PP_FEAT_RDM_SUPPORT */
    {
	id:		FV_ID_NET_IP_AUTO_CONFIG_PROTO,
	cfgkey:		"network.ip_auto_config_proto"
    },
    {
	id:		FV_ID_NET_PREF_HOSTNAME,
	cfgkey:		"network.pref_hostname"
    },
    {
	id:		FV_ID_NET_IPADDR,
	cfgkey:		"network.ipaddr"
    },
    {
	id:		FV_ID_NET_NETMASK,
	cfgkey:		"network.netmask"
    },
    {
	id:		FV_ID_NET_GATEWAY,
	cfgkey:		"network.gateway"
    },
    {
	id:		FV_ID_NET_DNS_IP_1,
	cfgkey:		"network.dns_ip_1"
    },
    {
	id:		FV_ID_NET_DNS_IP_2,
	cfgkey:		"network.dns_ip_2"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
net_basic_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_NET_BASIC, ACL_OBJ_NET);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    const char * auto_config = fh->fv[FV_ID_NET_IP_AUTO_CONFIG_PROTO].val.s;
    if (!strcmp(auto_config, "bootp") || !strcmp(auto_config, "dhcp")) {
	fh->fv[FV_ID_CLUSTER_IPADDR].flags  |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_CLUSTER_NETMASK].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_CLUSTER_GATEWAY].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_NET_IPADDR].flags   |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_NET_NETMASK].flags  |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_NET_GATEWAY].flags  |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_NET_DNS_IP_1].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_NET_DNS_IP_2].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    }
    if (strcmp(auto_config, "dhcp")) {
	fh->fv[FV_ID_NET_PREF_HOSTNAME].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    }
    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    if (*fh->fv[FV_ID_CLUSTER_IPADDR].val.s != '\0') {
	if (!net_common_check_ips(wp, fh->fv[FV_ID_CLUSTER_IPADDR].val.s,
				  fh->fv[FV_ID_CLUSTER_NETMASK].val.s,
				  ~CHECK_AGAINST_LAN, _("IP range of the LAN subnet"))) {
	    return -1;
	}
    }
    if (*fh->fv[FV_ID_CLUSTER_IPADDR].val.s == '\0') {
	if (!net_common_check_ips(wp, fh->fv[FV_ID_NET_IPADDR].val.s,
				  fh->fv[FV_ID_NET_NETMASK].val.s,
				  ~CHECK_AGAINST_LAN, _("IP range of the LAN subnet"))) {
	    return -1;
	}
    }
    return 0;
}
