#include <liberic_net.h>
#include <pp/intl.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {
    {
	id:		FV_ID_NET_LANIF_SPEED_ETH0,
	cfgkey:		"network.eth_speed"
    },
    {
	id:		FV_ID_NET_LANIF_DUPLEX_ETH0,
	cfgkey:		"network.eth_duplex"
    },
    {
	id:		FV_ID_NET_LANIF_MAC_ETH0,
	cfgkey:		"network.mac"
    },
#if defined (PP_FEAT_ETHERNET_FAILOVER)
    {
	id:		FV_ID_NET_LANIF_FAILOVER_ENABLED,
	cfgkey:		"network.failover_enabled"
    },
    {
	id:		FV_ID_NET_LANIF_FAILOVER_PING_SECONDS,
	cfgkey:		"network.failover_ping_seconds"
    },
    {
	id:		FV_ID_NET_LANIF_FAILOVER_TIMEOUT_SECONDS,
	cfgkey:		"network.failover_timeout_seconds"
    },
#endif /* PP_FEAT_ETHERNET_FAILOVER */
#if defined (PP_FEAT_JUMBO_FRAME_SUPPORT)
    {
	id:		FV_ID_NET_LANIF_JUMBOFRAME_ENABLED,
	cfgkey:		"network.jumboframe_enabled"
    },
    {
	id:		FV_ID_NET_LANIF_JUMBOFRAME_SIZE,
	cfgkey:		"network.jumboframe_size"
    },
#endif /* PP_FEAT_JUMBO_FRAME_SUPPORT */
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int eth_interface_state_asp(int eid, webs_t wp, int argc, char **argv);

int
net_lanif_tmpl_init(void)
{
    form_handler_t * fh;

    if (net_common_tmpl_init() != 0) return -1;

    /* register ASPs */
    websAspDefine("ethInterfaceState", eth_interface_state_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_NET_LANIF, ACL_OBJ_NET);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
    if (!strcmp(websGetVar(wp, "allow_mac_change", ""), "")) {
	fh->fv[FV_ID_NET_LANIF_MAC_ETH0].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    }
    fh->fv[FV_ID_NET_LANIF_MAC_ETH0].flags |= FV_FLAG_DONT_SAVE;
#if defined (PP_FEAT_ETHERNET_FAILOVER)
    if (!strcmp(fh->fv[FV_ID_NET_LANIF_FAILOVER_ENABLED].val.s, "no")) {
	fh->fv[FV_ID_NET_LANIF_FAILOVER_PING_SECONDS].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_NET_LANIF_FAILOVER_TIMEOUT_SECONDS].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    }
#endif /* PP_FEAT_ETHERNET_FAILOVER */
#if defined (PP_FEAT_JUMBO_FRAME_SUPPORT)
    if (!strcmp(fh->fv[FV_ID_NET_LANIF_JUMBOFRAME_ENABLED].val.s, "no")) {
	fh->fv[FV_ID_NET_LANIF_JUMBOFRAME_SIZE].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    }
#endif /* PP_FEAT_JUMBO_FRAME_SUPPORT */

    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    if (strcmp(websGetVar(wp, "allow_mac_change", ""), "")) {
        /* save MAC to system layer */
        pp_cfg_set_at_layer(PP_PROFILE_SYSTEM,
                            fh->fv[FV_ID_NET_LANIF_MAC_ETH0].val.s,
                            fh->fv[FV_ID_NET_LANIF_MAC_ETH0].cfgkey);
        pp_cfg_save_layer(PP_PROFILE_SYSTEM, DO_FLUSH);
    }

    return 0;
}

static int
eth_interface_state_asp(int eid, webs_t wp UNUSED, int argc, char **argv)
{
    char * state_str;

    if (argc == 1 && (state_str = pp_eth_get_link_state(argv[0])) != NULL) {
	ejSetResult(eid, state_str);
	free(state_str);
    } else {
	ejSetResult(eid, _("Unknown"));
    }

    return 0;
}
