#include <liberic_net.h>
#include <liberic_misc.h>
#include <pp/setup_proto.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

#ifdef PP_FEAT_WLAN

FV_SPEC = {
    {
	id:		FV_ID_NET_WLAN_ESSID,
	cfgkey:		"wlan.essid"
    },
    {
	id:		FV_ID_NET_WLAN_SECURITY_TYPE,
	cfgkey:		"wlan.security_type"
    },
# if 0
    /* diable until driver is capable of adhoc mode */
      
    {
	id:		FV_ID_NET_WLAN_MODE,
	cfgkey:		"wlan.mode"
    },
# endif
};

int
net_wlan_tmpl_init(void)
{
    form_handler_t * fh;

    if (net_common_tmpl_init() != 0) return -1;
    
    fh = CREATE_FH_INSTANCE(TEMPLATE_NET_WLAN, ACL_OBJ_NET);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

#else /* !PP_FEAT_WLAN */

int net_wlan_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_WLAN */
