#include <liberic_net.h>
#include <liberic_misc.h>
#include <pp/setup_proto.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_WLAN

FV_SPEC = {
};

static int get_wlan_signal_level_asp(int eid, webs_t wp, int argc, char ** argv);
static int get_wlan_ap_mac_asp(int eid, webs_t wp, int argc, char ** argv);

int
net_wlan_status_tmpl_init(void)
{
    form_handler_t * fh;

    if (net_common_tmpl_init() != 0) return -1;

    websAspDefine("GetWlanSignalLevel", get_wlan_signal_level_asp);
    websAspDefine("GetWlanAPMAC", get_wlan_ap_mac_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_NET_WLAN_STATUS, ACL_OBJ_NET);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
get_wlan_signal_level_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
    int siglvl;
    char sigstr[100];
    siglvl = eric_net_wlan_get_signal_level();

    if (siglvl < 0) {
	// error
	ejSetResult(eid, _("no signal"));
    } else if (siglvl == 0) {
	// really no signal
	ejSetResult(eid, _("no signal"));
    } else {
	// siglvl > 0
	snprintf(sigstr, sizeof(sigstr), "-%d dB", siglvl);
	ejSetResult(eid, sigstr);
    }
    return 0;
}

static int
get_wlan_ap_mac_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
    char * mac = eric_net_wlan_get_ap_mac();

    ejSetResult(eid, mac ? mac : _("unknown"));
    free (mac);
    
    return 0;
}


#else /* !PP_FEAT_WLAN */

int net_wlan_status_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_WLAN */
