#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/intl.h>
#include <pp/powerswitch.h>
#include <liberic_config.h>
#include <liberic_misc.h>
#include <pp/cfg.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#if defined(PP_FEAT_POWER_CTRL_ENABLE)

FV_SPEC = {
};

static int post_save_hook(webs_t wp, form_handler_t * fh);
static int pc_ports_set_vars_asp(int eid, webs_t wp, int argc, char ** argv);

int
power_control_ports_tmpl_init(void)
{
    form_handler_t * fh;
  
    /* register ASPs */
    websAspDefine("pcPortsSetVars", pc_ports_set_vars_asp);
    fh = CREATE_FH_INSTANCE(TEMPLATE_POWER_CONTROL_PORTS, ACL_OBJ_POWER_CONTROL);
    fh->post_save_hook = post_save_hook;

   
    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_save_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    int switch_on, res;
    
    /* open power switch on serial port 1 */
    power_control_common_power_switch_login(wp, PP_POWER_PORT_ID_SERIAL_1);
    
    /* open power switch on serial port 2 */
    power_control_common_power_switch_login(wp, PP_POWER_PORT_ID_SERIAL_2);

    if (form_button_clicked(wp, "action_power_on_port")
	|| form_button_clicked(wp, "action_power_off_port")) {
	u_char kvm_unit;
	u_short kvm_port;
	if (pp_kvm_get_unit_port_for_video_link(0, &kvm_unit, &kvm_port) != 0) {
	    /* FIXME */
	    kvm_unit = 0;
	    kvm_port = 0;
	}
	switch_on = form_button_clicked(wp, "action_power_on_port") ? 1 : 0;

	/* TODO: at some point we may have to deal with kvm unit != 0 */
	if (!pp_kvm_switch_allowed(wp->user, 0 /*unit*/, kvm_port)) {
	    set_response(wp, ERIC_RESPONSE_ERROR, perm_denied_msg);
	    goto finish;
	}

	res = pp_power_switch_kvm_ports(kvm_unit, kvm_port, switch_on);
	set_response(wp, res ? ERIC_RESPONSE_ERROR : ERIC_RESPONSE_OK,
		     _("Power switch %s."), res ? _("failed") : _("performed"));
    }
    
    /*
     * Close power switches on request cleanup, so other
     * templates and ASPs can reuse the connections
     */
 finish:    
    wp->close_power_switches = 1; 
    return 0;
}

static int
pc_ports_set_vars_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char ** argv UNUSED)
{
    char var_name[MAX_OPT_KEY_LEN + 1];
    char var_value[MAX_OPT_VALUE_LEN + 1];
    int i;

    /* open power switch on serial port 1 */
    power_control_common_power_switch_login(wp, PP_POWER_PORT_ID_SERIAL_1);
    
    /* open power switch on serial port 2 */
    power_control_common_power_switch_login(wp, PP_POWER_PORT_ID_SERIAL_2);

    /* get power switch ports for current kvm port and write it to asp */
    {
	int display_kvm_power = 1;
	int kvm_pwrport_shown = 0;
	int kvm_pwrport_cnt = 0;
	u_char kvm_unit;
	u_short kvm_port;
	if (pp_kvm_get_unit_port_for_video_link(0, &kvm_unit, &kvm_port) == 0) {
	    snprintf(var_name, sizeof(var_name),
                     "unit[%u].port[%u].powerports._s_", kvm_unit, kvm_port);
	    pp_cfg_get_int(&kvm_pwrport_cnt, var_name);
	}

	for (i = 0; i < kvm_pwrport_cnt; ++i) {
	    char kvm_serial_port[MAX_OPT_VALUE_LEN + 1];
	    char dev_str[MAX_OPT_VALUE_LEN + 1];
	    char port_str[MAX_OPT_VALUE_LEN + 1];
	    char switch_id_str[MAX_OPT_VALUE_LEN + 1];
	    char * power_name;
	    char * kvm_power_port;
	    char * cur_sw_id_str;
	    u_int port_id;
	    int serial_id;

	    snprintf(var_name, sizeof(var_name),
                     "unit[%u].port[%u].powerports[%u]", kvm_unit, kvm_port, i);
            if (PP_FAILED(pp_cfg_get_nodflt(&kvm_power_port, var_name))) {
                continue;
	    }
	    if (strlen(kvm_power_port) > MAX_OPT_KEY_LEN) {
		free(kvm_power_port);
		continue;
	    }

	    /* parse config string */
	    if (sscanf(kvm_power_port, "%[^:]:%[^:]:%[^:]:%s", kvm_serial_port, dev_str, port_str, switch_id_str) != 4) {
		free(kvm_power_port);
		continue;
	    }

	    free(kvm_power_port);

	    power_name = pp_power_get_long_name(switch_id_str);
	    serial_id = strtol(kvm_serial_port, NULL, 10) + 1;
	    port_id = pp_power_map_serial_port_to_id(serial_id);

	    /* FIXME: what happens if port is not open? */

	    cur_sw_id_str = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_ID, port_id);

	    if (cur_sw_id_str) {
		if (strcmp(cur_sw_id_str, switch_id_str)) {
		    display_kvm_power = 0;
		} else {	
		    char * lst_devname  = NULL;
		    char * lst_portname = NULL;
		    int dev = strtol(dev_str, NULL, 10);
		    int port = strtol(port_str, NULL, 10);
		    
		    lst_devname = pp_power_get_name(0, dev, PWR_OBJ_DEVICE, port_id);
		    lst_portname = pp_power_get_name(port, 0, PWR_OBJ_PORT, port_id);

		    if (lst_devname) {
			snprintf(var_value, sizeof(var_value),
				 "Serial %d - %s - %s - %s", serial_id, power_name, lst_devname, lst_portname);
		    } else {
			snprintf(var_value, sizeof(var_value),
				 "Serial %d - %s - %s", serial_id, power_name, lst_portname);
		    }
		    form_var_vec_name("_kvm_powerport", kvm_pwrport_shown,
                                      var_name, sizeof(var_name));	
		    websSetVar(wp, var_name, var_value);

		    kvm_pwrport_shown++;
		    free(lst_devname);
		    free(lst_portname);
		}
		free (cur_sw_id_str);	    
	    }
	}
    
	snprintf(var_name, sizeof(var_name), "%d", kvm_pwrport_shown);
	websSetVar(wp, "_kvm_powerport_cnt", var_name);
	websSetVar(wp, "_display_kvm_power", display_kvm_power ? "yes" : "no");
    }

    /*
     * Close power switches on request cleanup, so other
     * templates and ASPs can reuse the connections
     */
    wp->close_power_switches = 1;
    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_control_ports_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
