#include <liberic_cert.h>
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

static int cert_get_csr_info_asp(int eid, webs_t wp, int argc, char ** argv);

int
sec_server_cert_common_tmpl_init(void)
{
    static int initialized = 0;

    if (!initialized) {
	/* register ASPs */
	websAspDefine("certGetCSRInfo", cert_get_csr_info_asp);
	initialized = 1;
    }

    return 0;
}

static int
cert_get_csr_info_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    char buf[1024];
    int error;

    eric_cert_get_csr_info(buf, sizeof(buf), &error);
    ejSetResult(eid, error ? "" : buf);

    return 0;
}
