#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

FV_SPEC = {
    {
	id:		FV_ID_SEC_SPW_ENABLED,
	cfgkey:		"security.strong_pw.enabled"
    },
    {
	id:		FV_ID_SEC_SPW_MIN_LEN,
	cfgkey:		"security.strong_pw.length.min"
    },
    {
	id:		FV_ID_SEC_SPW_MAX_LEN,
	cfgkey:		"security.strong_pw.length.max"
    },
    {
	id:		FV_ID_SEC_SPW_CHAR_LOWER,
	cfgkey:		"security.strong_pw.charset.lower"
    },
    {
	id:		FV_ID_SEC_SPW_CHAR_UPPER,
	cfgkey:		"security.strong_pw.charset.upper"
    },
    {
	id:		FV_ID_SEC_SPW_CHAR_NUMERIC,
	cfgkey:		"security.strong_pw.charset.numeric"
    },
    {
	id:		FV_ID_SEC_SPW_CHAR_SPECIAL,
	cfgkey:		"security.strong_pw.charset.special"
    },
    {
	id:		FV_ID_SEC_SPW_HISTORY,
	cfgkey:		"security.strong_pw.history"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
sec_strong_pw_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_SEC_SPW, ACL_OBJ_SECURITY);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED,  form_handler_t * fh) {
    if(strcmp(fh->fv[FV_ID_SEC_SPW_ENABLED].val.s, "yes")) {
        fh_disable_validate_and_save(fh, FV_ID_SEC_SPW_ENABLED);
    }
    
    return PP_SUC;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh) {
    int min, max;
    
    /* check min <= max length - range is already validated! */
    min = atoi(fh->fv[FV_ID_SEC_SPW_MIN_LEN].val.s);
    max = atoi(fh->fv[FV_ID_SEC_SPW_MAX_LEN].val.s);
    
    if(max < min) {
        set_response(wp, ERIC_RESPONSE_ERROR,
                     _("Maximum password length is smaller than "
                       "minimum password length."));
        return PP_ERR;
    }

    return PP_SUC;
}

