#include <liberic_net.h>
#include <pp/cfg.h>
#include <pp/intl.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_SERIAL_1,
	cfgkey:		"serialport[0]._c_"
    },
    {
	id:		FV_ID_SERIAL_1_MODEM_LINE_SPEED,
	cfgkey:		"serialport[0].modem.speed"
    },
    {
	id:		FV_ID_SERIAL_1_MODEM_INIT_STRING,
	cfgkey:		"serialport[0].modem.init"
    },
    {
	id:		FV_ID_SERIAL_1_MODEM_BOARD_IP,
	cfgkey:		"serialport[0].modem.board_ip"
    },
    {
	id:		FV_ID_SERIAL_1_MODEM_CLIENT_IP,
	cfgkey:		"serialport[0].modem.client_ip"
    },
    {
	id:		FV_ID_SERIAL_1_LINE_SPEED,
	cfgkey:		"serialport[0].passthrough.speed"
    },
    {
	id:		FV_ID_SERIAL_1_DATA,
	cfgkey:		"serialport[0].passthrough.data"
    },
    {
	id:		FV_ID_SERIAL_1_PARITY,
	cfgkey:		"serialport[0].passthrough.parity"
    },
    {
	id:		FV_ID_SERIAL_1_STOP,
	cfgkey:		"serialport[0].passthrough.stop"
    },
    {
	id:		FV_ID_SERIAL_1_HANDSHAKE,
	cfgkey:		"serialport[0].passthrough.handshake"
    },
#if defined PP_FEAT_IPMI_CLIENT_SERIAL
    {
	id:		FV_ID_SERIAL_1_IPMI_LINE_SPEED,
	cfgkey:		"serialport[0].ipmi.speed"
    },
    {
	id:		FV_ID_SERIAL_1_IPMI_DATA,
	cfgkey:		"serialport[0].ipmi.data"
    },
    {
	id:		FV_ID_SERIAL_1_IPMI_PARITY,
	cfgkey:		"serialport[0].ipmi.parity"
    },
    {
	id:		FV_ID_SERIAL_1_IPMI_STOP,
	cfgkey:		"serialport[0].ipmi.stop"
    },
    {
	id:		FV_ID_SERIAL_1_IPMI_HANDSHAKE,
	cfgkey:		"serialport[0].ipmi.handshake"
    },
#endif /* PP_FEAT_IPMI_CLIENT_SERIAL */
#if defined(PRODUCT_ERIC2) || defined(PRODUCT_ERICXP) || defined(PRODUCT_ERICG4)
    {
	id:		FV_ID_SERIAL_1_CONSOLE_SPEED,
	cfgkey:		"serialport[0].configlogin.speed",
    },
    {
	id:		FV_ID_SERIAL_1_CONSOLE_DATA,
	cfgkey:		"serialport[0].configlogin.data",
    },
    {
	id:		FV_ID_SERIAL_1_CONSOLE_PARITY,
	cfgkey:		"serialport[0].configlogin.parity",
    },
    {
	id:		FV_ID_SERIAL_1_CONSOLE_STOP,
	cfgkey:		"serialport[0].configlogin.stop",
    },
    {
	id:		FV_ID_SERIAL_1_CONSOLE_HANDSHAKE,
	cfgkey:		"serialport[0].configlogin.handshake",
    },          
#endif /* PRODUCT_ERIC2 || PRODUCT_ERICXP || PRODUCT_ERICG4*/
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
serial_1_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_SERIAL_1, ACL_OBJ_SERIAL);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    int modem_enabled = !strcmp(fh->fv[FV_ID_SERIAL_1].val.s, "modem");

    pp_log("pre_validate_hook#0\n");
    if (!modem_enabled) {
	fh->fv[FV_ID_SERIAL_1_MODEM_LINE_SPEED].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_SERIAL_1_MODEM_INIT_STRING].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_SERIAL_1_MODEM_BOARD_IP].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	fh->fv[FV_ID_SERIAL_1_MODEM_CLIENT_IP].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	pp_log("pre_validate_hook#1\n");
    }
    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    int modem_enabled, ipmi_enabled;
#if defined PP_FEAT_POWER_IPM220 && !defined(PP_FEAT_POWER_OTHER_EXTERNAL)
    int externalpower_enabled;
#endif

    pp_log("post_validate_hook#0\n");
#if defined(PRODUCT_RC1) || defined(PRODUCT_WINGLE)
    /* RC1 && Wingle have no telnet_enable (ssh_enable) setting - so we enable telnet (ssh) if passthrough is enabled */
    {
	const char * enabled = strcmp(fh->fv[FV_ID_SERIAL_1].val.s, "passthrough") ? "no" : "yes";
	pp_cfg_set(enabled, "network.telnet_enabled");		
	pp_cfg_set(enabled, "network.ssh_enabled");
	pp_log("post_validate_hook#1\n");		
    }
#endif /* PRODUCT_RC1 || PRODUCT_WINGLE */
    /* check modem IP addresses */
    modem_enabled = !strcmp(fh->fv[FV_ID_SERIAL_1].val.s, "modem");
    if (modem_enabled) {
	if (!strcmp(fh->fv[FV_ID_SERIAL_1_MODEM_BOARD_IP].val.s,
		    fh->fv[FV_ID_SERIAL_1_MODEM_CLIENT_IP].val.s)) {
	    set_response(wp, ERIC_RESPONSE_ERROR,
			 _("The '%s' and '%s' must be different."),
			 fh->fv[FV_ID_SERIAL_1_MODEM_BOARD_IP].label,
			 fh->fv[FV_ID_SERIAL_1_MODEM_CLIENT_IP].label);
	    return -1;
	}
	if (!net_common_check_ips(wp, fh->fv[FV_ID_SERIAL_1_MODEM_BOARD_IP].val.s,
				  "255.255.255.255", ~CHECK_AGAINST_MODEM,
				  fh->fv[FV_ID_SERIAL_1_MODEM_BOARD_IP].label)
	    || !net_common_check_ips(wp, fh->fv[FV_ID_SERIAL_1_MODEM_CLIENT_IP].val.s,
				     "255.255.255.255", ~CHECK_AGAINST_MODEM,
				     fh->fv[FV_ID_SERIAL_1_MODEM_CLIENT_IP].label)) {
	    return -1;
	}
	pp_log("post_validate_hook#2\n");
    }

    /* check for IPMI and maybe disable it */
    ipmi_enabled = !strcmp(fh->fv[FV_ID_SERIAL_1].val.s, "ipmi");
    if (ipmi_enabled) {
	pp_cfg_set("serial", "ipmi.medium._c_");
	pp_log("post_validate_hook#3\n");
    } else {
        char * ipmi_medium;
        pp_cfg_get(&ipmi_medium, "ipmi.medium._c_");
        if (!pp_strcmp_safe(ipmi_medium, "serial")) {
	    pp_cfg_set("none", "ipmi.medium._c_");
        }
        free(ipmi_medium);
	pp_log("post_validate_hook#4\n");
    }
    
#if defined PP_FEAT_POWER_IPM220 && !defined(PP_FEAT_POWER_OTHER_EXTERNAL)
    /* some products support only one external powerswitch with no special settings.
     * we have to set the type of this power switch manually for libpp_powerswitch  */
    externalpower_enabled = (strcmp(fh->fv[FV_ID_SERIAL_1].val.s, "externalpower") == 0);
    if (externalpower_enabled) {
        pp_cfg_set("ipmtty", "ps.serial[0]._c_");
	pp_log("post_validate_hook#5\n");
    }
#endif


#if 0
    /*
     * This is some stuff from a kim-stable -> MAIN merge - looks a bit wrong to
     * set this here. Disabled for now. (rwa)
     */
# if defined(PRODUCT_LARAXP) && defined(OEM_TANGTOP)	
    if (!fh->private->ext_is_enabled && fh->private->ext_do_enable) {
	eric_um_set_option(ERIC_UM_GLOBAL_P, "ps_serial1", "ipwr", &error);
	eric_um_set_option(ERIC_UM_GLOBAL_P, "ps_ipwr_dev_addr_serial1_0", "1", &error);
	eric_um_set_option(ERIC_UM_GLOBAL_P, "ps_ipwr_dev_addr_serial1_cnt", "1", &error);
    }
# endif /* PRODUCT_LARAXP && TANGTOP */
#endif /* 0 */

    return 0;
}
