#include <pp/cfg.h>
#include "eric_base.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_SERIAL_2,
	cfgkey:		"serialport[1]._c_"
    },
    {
	id:		FV_ID_SERIAL_2_LINE_SPEED,
	cfgkey:		"serialport[1].passthrough.speed"
    },
    {
	id:		FV_ID_SERIAL_2_DATA,
	cfgkey:		"serialport[1].passthrough.data"
    },
    {
	id:		FV_ID_SERIAL_2_PARITY,
	cfgkey:		"serialport[1].passthrough.parity"
    },
    {
	id:		FV_ID_SERIAL_2_STOP,
	cfgkey:		"serialport[1].passthrough.stop"
    },
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
serial_2_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_SERIAL_2, ACL_OBJ_SERIAL);
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(UNUSED webs_t wp, form_handler_t * fh)
{
#if defined PP_FEAT_POWER_IPM220 && !defined(PP_FEAT_POWER_OTHER_EXTERNAL)
    int externalpower_enabled;
    
    /* some products support only one external powerswitch with no special settings.
     * we have to set the type of this power switch manually for libpp_powerswitch  */
    externalpower_enabled = (strcmp(fh->fv[FV_ID_SERIAL_1].val.s, "externalpower") == 0);
    if (externalpower_enabled) {
        pp_cfg_set("ipmtty", "ps.serial[1]._c_");
    }
#else /* !PP_FEAT_POWER_IPM220 || PP_FEAT_POWER_OTHER_EXTERNAL */
    (void)fh;
#endif /* !PP_FEAT_POWER_IPM220 || PP_FEAT_POWER_OTHER_EXTERNAL */
    return 0;
}
