#include "eric_validate.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "wsIntrn.h"

FV_SPEC = {
    {
	id:		FV_ID_SERIAL,
	cfgkey:		"serial",
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
sn_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_SN, ACL_OBJ_SUPER);
    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    fh->fv[FV_ID_SERIAL].flags |= FV_FLAG_DONT_SAVE;
    return 0;
}

static int
post_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    /* save serial number to system profile */
    pp_cfg_set_at_layer(PP_PROFILE_SYSTEM,
	    fh->fv[FV_ID_SERIAL].val.s,
	    fh->fv[FV_ID_SERIAL].cfgkey);
    pp_cfg_save_layer(PP_PROFILE_SYSTEM, DO_FLUSH);
    return 0;
}

