#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "wsIntrn.h"
#include <pp/usb.h>

FV_SPEC = {
    {
	id:		FV_ID_USB_FORCE_FS,
	cfgkey:		"usb_dc[0].force_fs"
    },
};

static int usb_has_force_full_speed_asp(int eid, webs_t wp, int argc, char ** argv);

int
usb_dc_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("usbHasForceFullSpeed", usb_has_force_full_speed_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_USB_DC, ACL_OBJ_USB);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
usb_has_force_full_speed_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
    ejSetResult(eid, pp_usb_has_force_fs() ? "1" : "0");
    return 0;
}
