#ifdef PP_FEAT_MASS_STORAGE
#include <pp/intl.h>
#include <pp/usb.h>
#include "tmpl_vfloppy_common.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_VFLOPPY_EXTERN_INDEX,
	cfgkey:		"vfloppy.ms_index"
    },
    {
	id:		FV_ID_VFLOPPY_SMB_HOST,
	cfgkey:		"vfloppy.smb.host"
    },
    {
	id:		FV_ID_VFLOPPY_SMB_SHARE,
	cfgkey:		"vfloppy.smb.share"
    },
    {
	id:		FV_ID_VFLOPPY_SMB_FILE,
	cfgkey:		"vfloppy.smb.file"
    },
    {
	id:		FV_ID_VFLOPPY_SMB_USER,
	cfgkey:		"vfloppy.smb.user"
    },
    {
	id:		FV_ID_VFLOPPY_SMB_PASS,
	cfgkey:		"vfloppy.smb.pass"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
vfloppy_extern_tmpl_init(void)
{
    form_handler_t * fh;

    if (vfloppy_common_tmpl_init() != 0) return -1;

    fh = CREATE_FH_INSTANCE(TEMPLATE_VFLOPPY_EXTERN, ACL_OBJ_VFLOPPY);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp,  form_handler_t * fh)
{
    size_t i;
    int rv, error;
    int ret = -1;
   
    if (form_button_clicked(wp, "action_vfloppy_smb_set")) {
	u_int ms_index;
    	
	ms_index = pp_strtoul_10(fh->fv[FV_ID_VFLOPPY_EXTERN_INDEX].val.s, UINT_MAX, NULL);
	if (ms_index < PP_FEAT_USB_MASS_STORAGE_NO) {
	    /* No global validate - only our own template (manually) */
	    wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;

	    for (i = 0; i < fh->fv_cnt; ++i) {
		form_var_t * fv = &fh->fv[i];
		if (fv->flags & FV_FLAG_SKIP_VALIDATE) continue;
		if (!validate_form_var(wp, fv)) {
		    return -1;
		}
	    }

	    rv = pp_usb_ms_set_smb_image(ms_index,
					 fh->fv[FV_ID_VFLOPPY_SMB_HOST].val.s,
					 fh->fv[FV_ID_VFLOPPY_SMB_SHARE].val.s,
					 fh->fv[FV_ID_VFLOPPY_SMB_FILE].val.s,
					 fh->fv[FV_ID_VFLOPPY_SMB_USER].val.s,
					 fh->fv[FV_ID_VFLOPPY_SMB_PASS].val.s,
					 &error);
	    if (rv == 0) {
		vfloppy_data_t *vfd = &vfloppy_data[ms_index];
		vfd->owning_session = wp->session;
		vfd->is_loaded = 1;
		set_response(wp, ERIC_RESPONSE_OK, _("Image file set successfully"));
		ret = 0;
	    } else {
		set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(error));
	    }
	}
    } else {
	ret = 0;
    }

    return ret;
}
#endif /* PP_FEAT_MASS_STORAGE */
