#include <liberic_misc.h>
#include <pp/intl.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {
    {
	id:		FV_ID_VIDEO_PANEL_ID,
	cfgkey:		"video.panel_id"
    }
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int get_panel_id_asp(int eid, webs_t wp, int argc, char ** argv);

int
video_panel_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("getPanelID", get_panel_id_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_VIDEO_PANEL, ACL_OBJ_VIDEO);

    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    int panel_id = pp_strtol_10(fh->fv[FV_ID_VIDEO_PANEL_ID].val.s, 0, NULL);
    if (eric_misc_set_panel_id(panel_id)) {
	set_response(wp, ERIC_RESPONSE_ERROR, _("Could not change fixed host monitor resolution."));
	return -1;
    }
    return 0;
}

static int
get_panel_id_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
    int panel_id = eric_misc_get_panel_id();
    char panel_id_str[3];

    if (panel_id < 0) panel_id = 0;
    snprintf(panel_id_str, sizeof(panel_id_str), "%u", panel_id);
    ejSetResult(eid, panel_id_str);
    return 0;
}
