/* 
 * wsIntrn.h -- Internal GoAhead Web server header
 *
 * Copyright (c) GoAhead Software Inc., 1992-2000. All Rights Reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 */
 
#ifndef _WS_INTRN_H
#define _WS_INTRN_H 1

/******************************* Description *********************************/

/* 
 * Internal GoAhead Web Server header. This defines the Web private APIs
 * Include this header when you want to create URL handlers.
 */

/********************************** Defines **********************************/

/*
 * Define this to enable HTTP/1.1 keep alive support
 *	#define WEBS_KEEP_ALIVE_SUPPORT 1
 *
 * Define this to enable memory allocation and stack usage tracking
 *	#define B_STATS 1
 */

/********************************* Includes **********************************/

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <sys/poll.h>
#include <sys/stat.h>
#include <signal.h>
#include <unistd.h>
#include <pp/base.h>
#include <liberic_net.h>
#include "uemf.h"
#include "ejIntrn.h"
#include "webs.h"

/********************************* Defines ***********************************/
/* 
 *	Read handler flags and state
 */
#define WEBS_BEGIN		0x1	/* Beginning state */
#define WEBS_HEADER		0x2	/* Ready to read first line */
#define WEBS_POST		0x4	/* POST without content */
#define WEBS_POST_CLEN		0x8	/* Ready to read content for POST */
#define WEBS_PROCESSING		0x10	/* Processing request */
#define WEBS_KEEP_TIMEOUT	15000	/* Keep-alive timeout (15 secs) */
#define WEBS_TIMEOUT		60000	/* General request timeout (60) */

#define PAGE_READ_BUFSIZE	512	/* bytes read from page files */
#define MAX_PORT_LEN		10	/* max digits in port number */
#define WEBS_SYM_INIT		64	/* initial # of sym table entries */
#define	WEBS_VERSION_STR	"2.1.3" /* version of web server s/w */	
/*
 * URL handler structure. Stores the leading URL path and the handler
 * function to call when the URL path is seen.
 */ 
typedef struct {
	int	(*handler)(webs_t wp, char *urlPrefix, char *webDir,
			   int arg, char *url, char *path, 
			   char *query); /* Callback URL handler function */
	char	*webDir;		/* Web directory if required */
	char	*urlPrefix;		/* URL leading prefix */
	int	len;		        /* Length of urlPrefix for speed */
	int	arg;		        /* Argument to provide to handler */
	int	flags;			/* Flags */
} websUrlHandlerType;

/* 
 * Error code list
 */
typedef struct {
	int		code;		/* HTTP error code */
	const char	*msg;		/* HTTP error message */
} websErrorType;

/* 
 * Mime type list
 */
typedef struct {
	const char	*type;		/* Mime type */
	const char	*ext;		/* File extension */
} websMimeType;

/*
 * File information structure.
 */
typedef struct {
	u_long	size;			/* File length */
	int	isDir;			/* Set if directory */
	time_t	mtime;			/* Modified time */
} websStatType;

extern websMimeType	websMimeList[];		/* List of mime types */
extern sym_fd_t		websMime;		/* Set of mime types */

/******************************* Prototypes **********************************/

int	websAspOpen(void);
void	websAspClose(void);
void	websFormOpen(void);
void	websFormClose(void);
void  	websDefaultClose(void);
int 	websDefaultHandler(webs_t wp, char *urlPrefix,
			   char *webDir, int arg, char *url,
			   char *path, char *query);
int 	websFormHandler(webs_t wp, char *urlPrefix, char *webDir,
			int arg, char *url, char *path, char *query);
void 	websResponse(webs_t wp, int code, const char * cookie,
		     const char * additional_header,
		     const char * message, const char * redirect);
int 	websJavaScriptEval(webs_t wp, char *script);
int 	websPageReadData(webs_t wp, char *buf, int nBytes);
int	websPageOpen(webs_t wp, char *lpath, char *path, int mode, int perm);
void	websPageClose(webs_t wp);
void	websPageSeek(webs_t wp, long offset);
int	websPageStat(webs_t wp, char *lpath, char *path, websStatType *sbuf);
int	websPageIsDirectory(char *lpath);
void 	websSetRequestSocketHandler(webs_t wp, int mask, void (*fn)(webs_t wp));
int 	websSolutionHandler(webs_t wp, char *urlPrefix,
			    char *webDir, int arg, char *url,
			    char *path, char *query);
void 	websUrlHandlerClose(void);
int 	websUrlHandlerOpen(void);
char*	websGetDateString(websStatType* sbuf);
void	mem_image_download_cb(webs_t wp);
void	default_download_cb(webs_t wp);
#if defined(PP_FEAT_WS_MANAGEMENT)
void	wsman_download_cb(webs_t wp);
#endif

#endif /* _WS_INTRN_H */

/******************************************************************************/
