#!/usr/bin/perl -w

use strict;

sub parse_menu_file($) {
    my $menu = ();
    my $akt_entry = {};

    my $menu_file = shift || die "no menu file supplied\n";

    open(MF, "<$menu_file") or die "can't open $menu_file";

    while (<MF>) {
	if (/^\s*$/) { next; }
	if (/^[^\s]+/) {
	    $_ =~ s/^\s*(.*?)\s*$/\1/ ;
	    if ((my $menu_entry, my $icon) = split /\|/) {

	      if (defined $akt_entry->{"list"}) {
		  push @{$menu}, $akt_entry;
	      }
	      $akt_entry = {};
	      $akt_entry->{"list"} = ();
	      $akt_entry->{"name"} = $menu_entry;
	      $akt_entry->{"iconname"} = defined($icon) ? $icon : "";

	      ($akt_entry->{"shortname"} = $menu_entry) =~ s/\s//g;
	    }
	} else {
	    $_ =~ s/^\s*(.*?)\s*$/\1/ ;
	    if (!defined $akt_entry->{"name"}) {
		next;
	    }
	    s/^[\s]*//g;
	    if ((my $menu_entry, my $html, my $target) = split /\|/) {
		next if (!defined $menu_entry);
		my $entry = {};
		$entry->{"name"} = $menu_entry;
		if (defined $html) {
		    $entry->{"url"} = $html;
		}
		if (defined $target) {
		    $entry->{"target"} = $target;
		}
		push @{$akt_entry->{"list"}}, $entry;
	    }
	}
    }

    if (defined $akt_entry->{"list"}) {
	push @{$menu}, $akt_entry;
    }

    return $menu;
}


sub gen_menu($) {
    my $menu = shift || die "no menu structure\n";
    my $t = "";
    my $m = "#define __MENU_BLOCK__\n";

    $t .= "<td valign=\"top\" class=\"menu\">\n";
    $t .= "<table style=\"border-collapse:collapse\" cellpadding=\"0\" cellspacing=\"0\"><thead><tr><th></th></tr></thead><tfoot><tr><td></td></tr></tfoot>\n";
    $t .= "<tbody><tr style=\"height:35px;\"><td></td></tr></tbody>\n";
    for my $big_menu_item (@{$menu}) {
	my $name = $big_menu_item->{name};
	my $shortname = $big_menu_item->{shortname};
	my $iconname = $big_menu_item->{iconname};
	$t .= "<tbody><tr><td width=\"5\" align=\"right\"><img src=\"big_menu_bg_l.gif\"></td><td height=\"40\" class=\"menu_item\"><a class=\"menu_link\" href=\"javascript:toggleItem('$shortname')\"><img src=\"$iconname\" align=\"middle\" border=\"0\" alt=\"\">&nbsp;$name&nbsp;</a></td><td width=\"20\" align=\"left\"><img src=\"big_menu_bg_r.gif\"></td></tr></tbody>\n";
	$t .= "<tbody class=\"menublock\" id=\"$shortname\">\n";
	for my $small_menu_item (@{$big_menu_item->{"list"}}) {
	    my $sname = $small_menu_item->{'name'};
	    my $url = defined($small_menu_item->{'url'}) ? $small_menu_item->{'url'} : "";
	    my $url_cut = $url;
	    $url_cut =~ s/\.asp.*$//;
	    my $targetstr = defined($small_menu_item->{'target'}) ? "target=\"$small_menu_item->{'target'}\"" : "";
	    my $class = defined($url) ? "#MC_${url_cut}#" : "sub_menu_item";
	    if (defined($url)) {
		$m .= "#if \"__BASE_FILE__\" eq \"$url.in\"\n";
		$m .= "# define __MENU_BLOCK__ $shortname\n";
		$m .= "#endif\n";
	    }
	    $t .= "<tr><td colspan=\"3\"class=\"$class\">\n";
	    # add the link or static text if no url defined
	    if (defined($url)) {
		$t .= "  <a class=\"menu_link\" href=\"$url\" $targetstr><img src=\"#MI_${url_cut}#\" align=\"middle\" border=\"0\" alt=\"\">$sname</a>\n";
	    } else {
		$t .= "  $sname\n";
	    }
	    $t .= "</td></tr>\n";
	}
	$t .= "</tbody>\n";
    }
    $t .= "</table>\n";
    $t .= "<script type=\"text/javascript\">\n";
    $t .= "  <!--\n";
    $t .= "    setMenu(\"__MENU_BLOCK__\");\n";
    $t .= "  -->\n";
    $t .= "</script>\n";
    $t .= "</td>\n";
    return ($t, $m);
}

sub writefile($$) {
    my $filename = shift or die "no filename supplied";
    my $text = shift || "";

    open(FN, ">$filename") or die "can't write $filename";
    print FN $text;
    close(FN) or die "can't close $filename";
}

my $menu;
my $includetext;
my $includefilepp;

my $menu_file = shift || die "no menu definition file supplied: ./gen_menu <menufile>";

$menu = parse_menu_file($menu_file);

($includetext, $includefilepp) = gen_menu($menu);

writefile("_unprocessed/menu_macros.inc", $includefilepp);
writefile("_unprocessed/menu.inc", $includetext);

exit 0;
#
###############################################################################
# Emacs
#
# Local Variables:
# cperl-indent-level:4
# cperl-continued-statement-offset:4
# cperl-continued-brace-offset:-4
# cperl-brace-offset:0
# cperl-brace-imaginary-offset:0
# cperl-label-offset:-2
# cperl-hairy:t
# perl-tab-always-indent:nil
# End:
###############################################################################
