#define __t__ TEMPLATE_AUTH_LDAP
TMPL_BEGIN()

<script type="text/javascript">
  <!--

    function AdsUpdateState() {
#ifdef PP_TMPL_AUTH_MODE_SET
        var authLdapEnabled = (getElement("id", "auth_ldap_enabled_radio", 0).checked == true);
#else
        var authLdapEnabled = true;
#endif
        var userLdapServerTypeElem = getElement("name", FMS(FV_ID_AUTH_LDAP_USER_SERVER_TYPE), 0);
        var adsDomainNameElem = getElement("name", FMS(FV_ID_AUTH_LDAP_ADS_DOMAIN_NAME), 0);

	adsDomainNameElem.disabled = (!authLdapEnabled || userLdapServerTypeElem.value != "ads");
    }

    function SSLUpdateState() {
#ifdef PP_TMPL_AUTH_MODE_SET
        var authLdapEnabled = (getElement("id", "auth_ldap_enabled_radio", 0).checked == true);
#else
        var authLdapEnabled = true;
#endif
        var useSSL = getElement("name", FMS(FV_ID_AUTH_LDAP_SSL), 0).checked;
        var port = getElement("name", FMS(FV_ID_AUTH_LDAP_PORT), 0);
        var SSLport = getElement("name", FMS(FV_ID_AUTH_LDAP_SSL_PORT), 0);

	port.disabled = !authLdapEnabled || useSSL;
        SSLport.disabled = !authLdapEnabled || !useSSL;
    }

    function AuthLdapSetState(enabled) {
	var elementNames = new Array(FMS(FV_ID_AUTH_LDAP_USER_HOST),
				     FMS(FV_ID_AUTH_LDAP_SSL),
#if defined(PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS)
				     FMS(FV_ID_AUTH_LDAP_SECRET),
				     FMS(FV_ID_AUTH_LDAP_USER_BASE_SEARCH),
#else /* PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS */
				     FMS(FV_ID_AUTH_LDAP_LOGIN_ATTR_TYPE),
				     FMS(FV_ID_AUTH_LDAP_USER_OBJECTCLASS),
				     FMS(FV_ID_AUTH_LDAP_USER_SEARCH_SUBFILTER),
#endif /* PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS */
				     FMS(FV_ID_AUTH_LDAP_USER_SERVER_TYPE),
				     FMS(FV_ID_AUTH_LDAP_USER_BASE_DN));
	var i;
	for (i = 0; i < elementNames.length; i++) {
	    var element = getElement("name", elementNames[i], 0);
	    element.disabled = !enabled;
	}
	AdsUpdateState();
        SSLUpdateState();
     }

  -->
</script>

#ifndef PP_TMPL_AUTH_MODE_SET
VARIABLE(FMS(FV_ID_AUTH_LDAP_MODE), "ldap")
#endif

DIALOGTABLE_BEGIN()
  <tr>
    <td class="settings_fieldname settings_padder">A_("User LDAP Server")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_USER_HOST);%> type="text" name=FMS(FV_ID_AUTH_LDAP_USER_HOST) maxlength="128" size="32"
             value="<% writeEsc(FM(FV_ID_AUTH_LDAP_USER_HOST)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_USER_HOST);%>
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname_checkbox settings_padder">
      <input <%isDisabled(FV_ID_AUTH_LDAP_SSL);%> type="checkbox"
       name=FMS(FV_ID_AUTH_LDAP_SSL) value="yes" onChange="SSLUpdateState()"
       <% if (FM(FV_ID_AUTH_LDAP_SSL) == "yes") { write("checked"); } %>>
      DIALOGTABLE_SPACER_OPTION()
      A_("SSL enabled")
      <%isDefault(FV_ID_AUTH_LDAP_SSL);%>
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname settings_padder">A_("Port")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_PORT);%> type="text"
       name=FMS(FV_ID_AUTH_LDAP_PORT) maxlength="5" size="6"
       value="<% writeEsc(FM(FV_ID_AUTH_LDAP_PORT)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_PORT);%>
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname settings_padder">A_("SSL Port")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_SSL_PORT);%> type="text"
       name=FMS(FV_ID_AUTH_LDAP_SSL_PORT) maxlength="5" size="6"
       value="<% writeEsc(FM(FV_ID_AUTH_LDAP_SSL_PORT)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_SSL_PORT);%>
    </td>
  </tr>
#if defined(PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS)
  <tr>
    <td class="settings_fieldname settings_padder">A_("DN of administrative User")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_USER_BASE_DN);%> type="text" name=FMS(FV_ID_AUTH_LDAP_USER_BASE_DN) maxlength="256" size="32"
             value="<% writeEsc(FM(FV_ID_AUTH_LDAP_USER_BASE_DN)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_USER_BASE_DN);%>
    </td>
  </tr>
  <tr>
   <td class="settings_fieldname settings_padder">A_("Secret string")
    DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_SECRET);%> type="password"
       name=FMS(FV_ID_AUTH_LDAP_SECRET) maxlength="32" size="32">
      <%isDefault(FV_ID_AUTH_LDAP_SECRET);%>
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname settings_padder">A_("User search DN")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_USER_BASE_SEARCH);%> type="text" name=FMS(FV_ID_AUTH_LDAP_USER_BASE_SEARCH) maxlength="256" size="32"
             value="<% writeEsc(FM(FV_ID_AUTH_LDAP_USER_BASE_SEARCH)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_USER_BASE_SEARCH);%>
    </td>
  </tr>
#else /* PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS */
    <td class="settings_fieldname settings_padder">A_("Base DN of User LDAP Server")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_USER_BASE_DN);%> type="text" name=FMS(FV_ID_AUTH_LDAP_USER_BASE_DN) maxlength="256" size="32"
             value="<% writeEsc(FM(FV_ID_AUTH_LDAP_USER_BASE_DN)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_USER_BASE_DN);%>
    </td>
  </tr>
#endif /* PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS */
  <tr>
    <td class="settings_fieldname settings_padder">A_("Type of external LDAP Server")
      DIALOGTABLE_SPACER_PADDED()
      <select <%isDisabled(FV_ID_AUTH_LDAP_USER_SERVER_TYPE);%> name=FMS(FV_ID_AUTH_LDAP_USER_SERVER_TYPE) onChange="AdsUpdateState()">
        <option value="generic" <% if (FM(FV_ID_AUTH_LDAP_USER_SERVER_TYPE) == "generic") { write("selected"); } %>> A_("Generic LDAP server")
	<option value="nds" <% if (FM(FV_ID_AUTH_LDAP_USER_SERVER_TYPE) == "nds") { write("selected"); } %>> A_("Novell Directory Service")
	<option value="ads" <% if (FM(FV_ID_AUTH_LDAP_USER_SERVER_TYPE) == "ads") { write("selected"); } %>> A_("Microsoft Active Directory")
      </select>
      <%isDefault(FV_ID_AUTH_LDAP_USER_SERVER_TYPE);%>
    </td>
  </tr>
#ifndef PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS
  <tr>
    <td class="settings_fieldname settings_padder">A_("Name of login-name attribute")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_LOGIN_ATTR_TYPE);%> type="text" name=FMS(FV_ID_AUTH_LDAP_LOGIN_ATTR_TYPE) maxlength="64" size="32"
             value="<% writeEsc(FM(FV_ID_AUTH_LDAP_LOGIN_ATTR_TYPE)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_LOGIN_ATTR_TYPE);%>
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname settings_padder">A_("Name of user-entry objectclass")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_USER_OBJECTCLASS);%> type="text" name=FMS(FV_ID_AUTH_LDAP_USER_OBJECTCLASS) maxlength="64" size="32"
             value="<% writeEsc(FM(FV_ID_AUTH_LDAP_USER_OBJECTCLASS)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_USER_OBJECTCLASS);%>
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname settings_padder">A_("User search subfilter")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_USER_SEARCH_SUBFILTER);%> type="text" name=FMS(FV_ID_AUTH_LDAP_USER_SEARCH_SUBFILTER) maxlength="256"
             size="32" value="<% writeEsc(FM(FV_ID_AUTH_LDAP_USER_SEARCH_SUBFILTER)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_USER_SEARCH_SUBFILTER);%>
    </td>
  </tr>
#endif /* !PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS */
  <tr id="ADS">
    <td class="settings_fieldname settings_padder">A_("Active Directory Domain")
      DIALOGTABLE_SPACER_PADDED()
      <input <%isDisabled(FV_ID_AUTH_LDAP_ADS_DOMAIN_NAME);%> type="text" name=FMS(FV_ID_AUTH_LDAP_ADS_DOMAIN_NAME) maxlength="256" size="32"
             value="<% writeEsc(FM(FV_ID_AUTH_LDAP_ADS_DOMAIN_NAME)); %>">
      <%isDefault(FV_ID_AUTH_LDAP_ADS_DOMAIN_NAME);%>
    </td>
  </tr>
DIALOGTABLE_END()
<br>
TMPL_END()
