#define __t__ TEMPLATE_IPMI_CHASSIS_INFO
TMPL_BEGIN()

#if defined(PP_FEAT_IPMI_SERVER)
  <% _ipmi_enabled = 1; %>
#else
  <% _ipmi_enabled = (FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != "none" && FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != ""); %>
#endif

  COND_SHOW_BEGIN(!_ipmi_enabled)
    NOTICE_BEGIN(center)
      A_("IPMI support is not enabled. You should check the") IPMI_SETTINGS().
    NOTICE_END()
  COND_SHOW_END(!_ipmi_enabled)

  COND_SHOW_BEGIN(_ipmi_enabled)
    DIALOGTABLE_BEGIN()
        <tr>
            <td class="settings_fieldname bold">A_("Power is:")</td>
            <td class="settings_field"><% if (_ipmi_enabled) write(ipmiGetPowerState()); %></td>
        </tr>
        <tr>
            <td class="settings_fieldname bold">A_("Power On Counter:")</td>
            <td class="settings_field"><% if (_ipmi_enabled) write(ipmiGetPowerCounter()); %></td>
        </tr>
        <tr>
            <td class="settings_fieldname bold">A_("Last Restart Cause:")</td>
            <td class="settings_field"><% if (_ipmi_enabled) write(ipmiGetRestartCause()); %></td>
        </tr>
        <tr>
            <td class="buttons" colspan="2">SUBMIT_BUTTON(T_("Refresh"), "refresh", "refresh", "")</td>
        </tr>
    DIALOGTABLE_END()
  COND_SHOW_END(_ipmi_enabled)

TMPL_END()
