#define __t__ TEMPLATE_IPMI_SEL
TMPL_BEGIN()

#if defined(PP_FEAT_IPMI_SERVER)
  <% _ipmi_enabled = 1; %>
#else
  <% _ipmi_enabled = (FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != "none" && FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != ""); %>
#endif

  COND_SHOW_BEGIN(!_ipmi_enabled)
    NOTICE_BEGIN(center)
      A_("IPMI support is not enabled. You should check the") IPMI_SETTINGS().
    NOTICE_END()
  COND_SHOW_END(!_ipmi_enabled)

  COND_SHOW_BEGIN(_ipmi_enabled)
#if !defined(PP_FEAT_RARITAN_DESIGN)
    DIALOGTABLE_BEGIN()
    <% if (_ipmi_enabled) __seltable = ipmiGetSelTable(); %>
#if defined(PP_FEAT_IPMI_CLIENT_QUERY_SEL_IN_BACKGROUND)
        <tr>
          <td class="center" colspan="6">
            CREATE_PAGES(ipmisel, sel_page_count, sel_current_page)
          </td>
        </tr>
#endif
        <tr class="loggingHeader">
            <td class="bold">A_("Event Type")</td>
            <td class="bold">A_("Date")</td>
            <td class="bold">A_("Time")</td>
            <td class="bold">A_("Source")</td>
            <td class="bold">A_("Description")</td>
            <td class="bold">A_("Direction")</td>
        </tr>
        <% if (_ipmi_enabled) write(__seltable); %>
#if defined(PP_FEAT_IPMI_CLIENT_QUERY_SEL_IN_BACKGROUND)
        <tr>
          <td class="center" colspan="6">
            CREATE_PAGES(ipmisel, sel_page_count, sel_current_page)
          </td>
        </tr>
#endif
    DIALOGTABLE_END()
    SUBMIT_BUTTON(T_("Clear"), "clear", "clear_log", "")
#if defined(PP_FEAT_IPMI_CLIENT_QUERY_SEL_IN_BACKGROUND)
    SUBMIT_BUTTON(T_("Invalidate SEL Cache"), "invalidate", "invalidate", "")
#else
    SUBMIT_BUTTON(T_("Refresh"), "refresh", "refresh", "")
#endif
#else
        <% if (_ipmi_enabled) __seltable = ipmiGetSelTable(); %>
	TABLE_SCRIPT()
#if defined(PP_FEAT_IPMI_CLIENT_QUERY_SEL_IN_BACKGROUND)
        <center>CREATE_PAGES(log, sel_page_count, sel_current_page)</center>
#endif
	<script>
	table_start('A_("Event Type")','A_("Date")','A_("Time")','A_("Source")','A_("Description")','A_("Direction")');
	</script>
        <% if (_ipmi_enabled) write(__seltable); %>
	<script>
	table_end();
	</script>
	<center>
	SUBMIT_BUTTON(T_("Clear"), "clear", "clear_log", "")
#if defined(PP_FEAT_IPMI_CLIENT_QUERY_SEL_IN_BACKGROUND)
        SUBMIT_BUTTON(T_("Invalidate SEL Cache"), "invalidate", "invalidate", "")
#else
	SUBMIT_BUTTON(T_("Refresh"), "refresh", "refresh", "")
#endif
	</center>
#endif	
  COND_SHOW_END(_ipmi_enabled)

TMPL_END()
