#define __t__ TEMPLATE_IPMI_SENSORS
TMPL_BEGIN()

#if defined(PP_FEAT_IPMI_SERVER)
  <% _ipmi_enabled = 1; %>
#else
  <% _ipmi_enabled = (FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != "none" && FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != ""); %>
#endif

  COND_SHOW_BEGIN(!_ipmi_enabled)
    NOTICE_BEGIN(center)
      A_("IPMI support is not enabled. You should check the") IPMI_SETTINGS().
    NOTICE_END()
  COND_SHOW_END(!_ipmi_enabled)

  COND_SHOW_BEGIN(_ipmi_enabled)
#if !defined(PP_FEAT_RARITAN_DESIGN)
    DIALOGTABLE_BEGIN()
        <tr class="loggingHeader">
            <td class="bold">&nbsp;&nbsp;&nbsp;</td>
            <td class="bold">A_("Type")</td>
            <td class="bold">A_("Name")</td>
            <td class="bold">A_("Status")</td>
            <td class="bold">A_("Reading")</td>
        </tr>
        <tr id="wait">
            <td colspan=5>A_("Loading sensor information, please wait...")</td>
        </tr>
        <% if (_ipmi_enabled) write(ipmiGetSensorTable()); %>
    DIALOGTABLE_END()
    SUBMIT_BUTTON(T_("Refresh"), "refresh", "refresh", "")
    <script type="text/javascript">
      <!--
        document.getElementById("wait").style.display = "none";
      -->
    </script>
#else
	TABLE_SCRIPT()
	<script>
	table_start('A_("Type")','A_("Name")','A_("Status")','A_("Reading")');
	</script>
        <% if (_ipmi_enabled) write(ipmiGetSensorTable()); %>
	<script>
	table_end();
	</script>
	<center>
	SUBMIT_BUTTON(T_("Refresh"), "refresh", "refresh", "")
	</center>
#endif	
  COND_SHOW_END(_ipmi_enabled)

TMPL_END()
