/*---------------------------------------------------------------------------

	CCUserObject.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for CCUserObject

---------------------------------------------------------------------------*/

#ifndef _CCUserObject_H_
#define _CCUserObject_H_

#include <pp/syms.h>
#include <pp/UserObject.h>

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class CCUserObject : public CUserObject
{
    public:

        CCUserObject() 
        { 
            strcpy (user, "CCUser");
            strcpy (userID, "");
            strcpy (group, "");
            strcpy (groupID, "");
        };

	virtual	DWORD GetUserObjectType() { return UO_TYPE_CC; };

        virtual BOOL IsAdministrator () { return TRUE; };

        virtual BOOL IsDiagnosticEnabled () { return FALSE; };

        virtual const char* GetUserName () { return user; };

        virtual const char* GetGroupName () { return group; };

        virtual const char* GetGroupID () { return groupID; };

	virtual DWORD GetPermission ( const char * NOTUSED(SecurityId), const char * NOTUSED(uniqueId) ) { return TR_PERM_READWRITE; };

	virtual DWORD GetNodePermission ( const char * NOTUSED(SecurityId) ) { return TR_PERM_READWRITE; };

	virtual DWORD GetAuthentication() { return TR_CC_AUTHENTICATED; } ;

        virtual BOOL AllowConcurrentAccess () { return TRUE; };

        virtual BOOL IsInterfaceEnabled ( const char * NOTUSED(InterfaceName) ) { return TRUE; };

        virtual const char* GetDialbackNumber () { return ""; };

	virtual BOOL IsPasswordExpired () { return FALSE; };

        virtual BOOL operator=( const CUserObject * NOTUSED(pUserObject)) { return FALSE; };

        virtual DWORD GetUserMenuAccessPermission () { return 0x0FFF; };

        virtual const char * GetUserID() { return userID; };
    private:

        char user[RDM_MAX_USER_NAME];
        char userID[RDM_MAX_USER_NAME];
        char group[RDM_MAX_USER_NAME];
        char groupID[RDM_MAX_USER_NAME];
};


#endif // #ifndef _UserObject_h_

