/**	
 *	@file	CSCInfo.cpp
 *	@brief	Implementation oc CCSCHandler
 *
 */

#include	<strings.h>
#include	<assert.h>
#include	<pp/syms.h>
#include	<pp/CSCInfo.h>
#include	<pp/CSCProtocol.h>
#include	<pp/SXDB_Parse.h>

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	static data
 *--------------------------------------*/

/*----------------------------------------
 *	CNetConn_RC4 Class
 *--------------------------------------*/

/*  --------------------------------------------------------------------*/

CCSCInfo::CCSCInfo()
{
	pFirst = NULL;
	pDevInfo = NULL;
}

/*  --------------------------------------------------------------------*/

void CCSCInfo::SetDeviceDescription(const char *pType, const char *pModel, const char *pProductName, const char *pVersion, const char *pName, const char *pCluster)
{
	char	str[200];
	char	cluster[50];
	int		length;

	if (pCluster != NULL)
		sprintf(cluster,"<Cluster>%s</Cluster>", pCluster);
	else
		cluster[0] = 0;

	length = sprintf(str,"<Device Type=\"%s\" ProductName=\"%s\" Model=\"%s\" Version=\"%s\"> <Name>%s</Name> %s </Device>",
					pType,pProductName,pModel,pVersion,pName,cluster) + 1;

	/* FIXME: who deletes this ? */
	pDevInfo = new char[length];
	assert(pDevInfo != NULL);
	strcpy(pDevInfo,str);
}

/*  --------------------------------------------------------------------*/

void CCSCInfo::AddProtocol( CCSCProtocol * pProtocol )
{
	if (pFirst == NULL)
		pFirst = pProtocol;
	else
	{
		CCSCProtocol * p = pFirst;
		while (p->pNext != NULL)
			p = p->pNext;
		p->pNext = pProtocol;
	}
}

/*  --------------------------------------------------------------------*/

CCSCProtocol * CCSCInfo::EnumProtocols( int index )
{
	CCSCProtocol *p = pFirst;
	while (index-- && p != NULL)
		p=p->pNext;
	return p;
}

/*  --------------------------------------------------------------------*/

char * CCSCInfo::MakeCSCInfo( int msgFormat, int * pLength )
{
	int					length;
	char			*	p;
	CCSCProtocol	*	pCSCProtocol;
	const char		*	pStart = "<CSC_Info>";
	const char		*	pEnd   = "</CSC_Info>";

	// Compute the length

	assert(pDevInfo != NULL);

	length = 5 + strlen(pStart) + strlen(pEnd) + strlen(pDevInfo);

	for (pCSCProtocol = pFirst;pCSCProtocol != NULL;pCSCProtocol = pCSCProtocol->pNext)
		length += strlen(pCSCProtocol->GetProtocolXML());

	p = new char[length];

	if (p == NULL)
		return p;

	p[0] = 0;

	if (msgFormat)
		strcpy(p,"    ");

	strcat(p,pStart);
	strcat(p,pDevInfo);

	for (pCSCProtocol = pFirst;pCSCProtocol != NULL;pCSCProtocol = pCSCProtocol->pNext)
		strcat(p,pCSCProtocol->GetProtocolXML());

	strcat(p,pEnd);

	if (msgFormat)
		* (int*) p = htonl(length);

	if (pLength != NULL)
		*pLength = length;

	return p;
}

/*  --------------------------------------------------------------------*/

bool CCSCInfo::ReceiveUDPMessage( CUDPListener * pUDP, int NOTUSED(ipAddress), char * pData, int count )
{
    int					cscLength;
	int					length;
	int					result;
	char		  *		pCSC;
	CSXDB_Parse			xmlParse;
	CSXDB_Element *		pNode;

	cscLength = ntohl( * (int*) pData );

	if (cscLength >= 16 && cscLength <= count && pData[cscLength-1] == 0)
	{
		result = xmlParse.Parse( &pData[4], strlen( &pData[4] ) );

		if (result >= 0)
		{
			if (xmlParse.GetDataBase() != NULL)
			{
				pNode = (CSXDB_Element*) xmlParse.GetDataBase()->Root();
				if (pNode != NULL)
				{
					pNode = (CSXDB_Element *) pNode->Child();
					if (pNode != NULL)
					{
						if (pNode->GetName() != NULL)
						{
							if (strcmp(pNode->GetName(),"CSC_Discover")==0)
							{
								// Send CSC_Info

								pCSC = MakeCSCInfo(1,&length);
								pUDP->ReturnMessage(pCSC,length);
								delete [] pCSC;
								return true;
							}
						}
					}
				}
			}
		}
	}
	return false;
}
